/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.FieldNumberOutOfRangeException;
import io.github.microserviceapipatterns.protobufgen.exception.FieldNumberReservedException;
import java.util.Objects;

public class FieldNumber
implements Comparable<FieldNumber> {
    private final int number;

    public FieldNumber(int number) {
        if (number < 1 || number > 0x1FFFFFFF) {
            throw new FieldNumberOutOfRangeException(number);
        }
        if (number >= 19000 && number <= 19999) {
            throw new FieldNumberReservedException();
        }
        this.number = number;
    }

    public int toInt() {
        return this.number;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldNumber that = (FieldNumber)o;
        return this.number == that.number;
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }

    @Override
    public int compareTo(FieldNumber fieldNumber) {
        return Integer.valueOf(this.number).compareTo(fieldNumber.number);
    }
}

