/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.Operation;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class MessageExchangePatternValidator
extends AbstractMDSLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void validateMessagePresenenceForExchangePattern(Operation nextOp) {
        String mep = nextOp.getMep();
        DataTransferRepresentation inDtr = nextOp.getRequestMessage();
        DataTransferRepresentation outDtr = nextOp.getResponseMessage();
        if (mep.equals("REQUEST_REPLY")) {
            if (inDtr == null) {
                this.error(nextOp.getName() + " is a REQUEST_REPLY operation, which expects a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr == null) {
                this.error(nextOp.getName() + " is a REQUEST_REPLY operation, which must deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        } else if (mep.equals("ONE_WAY")) {
            if (inDtr == null) {
                this.error(nextOp.getName() + " is a ONE_WAY operation, which expects a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr != null) {
                this.error(nextOp.getName() + " is a ONE_WAY operation, which should not deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        } else if (mep.equals("NOTIFICATION")) {
            if (inDtr != null) {
                this.error(nextOp.getName() + " is a NOTIFICATION operation, which should not expect a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr == null) {
                this.error(nextOp.getName() + " is a NOTIFICATION operation, which must deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        }
    }
}

