/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class MAPDecoratorValidator
extends AbstractMDSLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkRoleResponsibilityPatternCombination(EndpointContract nextEndpoint) {
        EList<Operation> opList = nextEndpoint.getOps();
        String role1 = nextEndpoint.getPrimaryRole();
        if (role1 == null || role1.equals("")) {
            this.info(nextEndpoint.getName() + " has no responsibility ", nextEndpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name());
            return;
        }
        for (int i = 0; i < opList.size(); ++i) {
            Operation nextOp = (Operation)opList.get(i);
            String responsibility = this.getResponsibilityPattern(nextOp);
            if (responsibility == null || responsibility.equals("")) continue;
            this.checkOperationResponsibilitySemantics(nextOp, responsibility);
            if (role1.equals("PROCESSING_RESOURCE")) continue;
            if (role1.equals("INFORMATION_HOLDER_RESOURCE")) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                continue;
            }
            if (role1.equals("MASTER_DATA_HOLDER") || role1.equals("OPERATIONAL_DATA_HOLDER") || role1.equals("DATA_TRANSFER_RESOURCE")) continue;
            if (role1.equals("REFERENCE_DATA_HOLDER")) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                if (responsibility.equals("STATE_CREATION_OPERATION") || responsibility.equals("STATE_TRANSITION_OPERATION")) {
                    this.warning(nextOp.getName() + " creates or updates state, somewhat unexpected in a reference data holder such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (!responsibility.equals("STATE_TRANSITION_OPERATION")) continue;
                this.warning(nextOp.getName() + " is a STATE_TRANSITION_OPERATION, somewhat unexpected in a reference data holder such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                continue;
            }
            if (role1.equals("LINK_LOOKUP_RESOURCE")) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                if (!responsibility.equals("STATE_TRANSITION_OPERATION")) continue;
                this.warning(nextOp.getName() + " updates state, somewhat unexpected in a link lookup resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                continue;
            }
            this.info(nextEndpoint.getName() + " unknown role " + role1, nextEndpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name());
        }
    }

    private void checkOperationResponsibilitySemantics(Operation operation, String responsibility) {
        if (operation.getResponseMessage() == null && "COMPUTATION_FUNCTION".equals(responsibility)) {
            this.warning(operation.getName() + " is a COMPUTATION_FUNCTION, and should therefore return something. Please add a response message.", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Responsibility());
        }
    }

    private void checkCommonDataEndpointConstraint(EndpointContract ep, Operation op, String responsibility) {
        if (responsibility.equals("COMPUTATION_FUNCTION")) {
            this.warning(op.getName() + " is a COMPUTATION_FUNCTION, somewhat unexpected in a data-oriented endpoint such as " + ep.getName(), op, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
        }
    }

    private String getResponsibilityPattern(Operation mdslOperation) {
        OperationResponsibility responsibility = mdslOperation.getResponsibility();
        if (responsibility == null) {
            return "";
        }
        if (responsibility.getCf() != null) {
            return responsibility.getCf();
        }
        if (responsibility.getSco() != null) {
            return responsibility.getSco();
        }
        if (responsibility.getRo() != null) {
            return responsibility.getRo();
        }
        if (responsibility.getSto() != null) {
            return responsibility.getSto();
        }
        if (responsibility.getOther() != null) {
            return responsibility.getOther();
        }
        return "";
    }
}

