/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPParameterBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ReportBinding;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class HTTPBindingValidator
extends AbstractMDSLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    void operationsActuallyDefinedInEndpointType(HTTPOperationBinding httpOperationBinding) {
        if (httpOperationBinding.getMethod() == HTTPVerb.TRACE || httpOperationBinding.getMethod() == HTTPVerb.HEAD || httpOperationBinding.getMethod() == HTTPVerb.OPTIONS) {
            this.warning("Operation " + httpOperationBinding.getBoundOperation() + " is bound to " + httpOperationBinding.getMethod().getName() + ", an HTTP verb that is not seen often in APIs. Prefer POST, PUT, PATCH, GET, DELETE", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_Method());
        }
        this.checkWhetherAllOperationsInContractAreBound(httpOperationBinding);
        this.checkOperationExistenceInContract(httpOperationBinding);
        this.checkErrorReportBindings(httpOperationBinding);
        this.checkSecurityPolicyBindings(httpOperationBinding);
    }

    private void checkSecurityPolicyBindings(HTTPOperationBinding httpOperationBinding) {
        EList<SecurityBinding> sbl = httpOperationBinding.getSecurityBindings();
        EndpointContract ec = this.findContract(httpOperationBinding);
        Operation op = this.findOperation(ec, httpOperationBinding.getBoundOperation());
        SecurityPolicies secPols = null;
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            secPols = operation.getPolicies();
        }
        if (secPols == null && sbl != null && sbl.size() > 0) {
            this.error("No policy definitions found in endpoint type operation, but the operation binding has one or more.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_SecurityBindings());
            return;
        }
        for (SecurityBinding sb : sbl) {
            boolean found = false;
            for (SecurityPolicy sp : secPols.getPolicyList()) {
                if (!sp.getName().equals(sb.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.error("No policy definition for " + sb.getName() + " found in endpoint type operation.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_SecurityBindings());
        }
    }

    private void checkErrorReportBindings(HTTPOperationBinding httpOperationBinding) {
        EList<ReportBinding> rpl = httpOperationBinding.getReportBindings();
        EndpointContract ec = this.findContract(httpOperationBinding);
        Operation op = this.findOperation(ec, httpOperationBinding.getBoundOperation());
        StatusReports responseReports = null;
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            responseReports = operation.getReports();
        }
        if (responseReports == null && rpl != null && rpl.size() > 0) {
            this.error("No report definitions found in endpoint type operation, but the operation binding has one or more.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_ReportBindings());
            return;
        }
        for (ReportBinding rp : rpl) {
            boolean found = false;
            for (StatusReport sr : responseReports.getReportList()) {
                if (!sr.getName().equals(rp.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.error("No report definition for " + rp.getName() + " found in endpoint type operation.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_ReportBindings());
        }
    }

    private boolean checkWhetherAllOperationsInContractAreBound(HTTPOperationBinding httpOperationBinding) {
        EndpointContract ec = this.findContract(httpOperationBinding);
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            return true;
        }
        this.error("Bound operation " + httpOperationBinding.getBoundOperation() + " is not defined in the endpoint type " + ec.getName() + ". Add it there or delete binding here.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_BoundOperation());
        return false;
    }

    private EndpointContract findContract(HTTPOperationBinding httpOperationBinding) {
        TechnologyBinding tp = (TechnologyBinding)httpOperationBinding.eContainer().eContainer().eContainer().eContainer();
        EndpointList eil = (EndpointList)tp.eContainer().eContainer();
        return eil.getContract();
    }

    private boolean checkOperationExistenceInContract(HTTPOperationBinding httpOperationBinding) {
        return true;
    }

    @Check
    void elementsActuallyDefinedInRequestPayload(HTTPParameterBinding parameterBinding) {
        HTTPOperationBinding httpOperationBinding = (HTTPOperationBinding)parameterBinding.eContainer();
        EndpointContract ec = this.findContract(httpOperationBinding);
        Operation op = this.findOperation(ec, httpOperationBinding.getBoundOperation());
        if (!this.isPresentInRequestPayload(parameterBinding.getBoundParameter(), op)) {
            this.error("Bound parameter " + parameterBinding.getBoundParameter() + " is not defined in the bound operation " + op.getName() + ". Add it there or delete binding here.", parameterBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPParameterBinding_BoundParameter());
        }
    }

    private boolean isPresentInRequestPayload(String boundParameter, Operation op) {
        DataTransferRepresentation rm = op.getRequestMessage();
        ElementStructure structure = rm.getPayload();
        if (structure == null) {
            return false;
        }
        return this.checkElements(structure, boundParameter);
    }

    private boolean checkElements(ElementStructure structure, String boundParameter) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                return this.checkElements(structure.getNp().getTr().getDcref().getStructure(), boundParameter);
            }
            if (structure.getPt() != null) {
                LinkedList nodes = Lists.newLinkedList();
                nodes.add(structure.getPt().getFirst());
                nodes.addAll(structure.getPt().getNexttn());
                for (TreeNode nextLevel1Node : nodes) {
                    if (nextLevel1Node.getPn() == null || nextLevel1Node.getPn().getAtomP() == null) continue;
                    atomicParameterList.add(nextLevel1Node.getPn().getAtomP());
                }
            } else if (structure.getNp().getGenP() != null && structure.getNp().getGenP().getName() != null && structure.getNp().getGenP().getName().equals(boundParameter)) {
                return true;
            }
        }
        for (AtomicParameter atomicParameter : atomicParameterList) {
            if (atomicParameter.getRat() == null || atomicParameter.getRat().getName() == null || !atomicParameter.getRat().getName().equals(boundParameter)) continue;
            return true;
        }
        return false;
    }

    private Operation findOperation(EndpointContract ec, String boundOperation) {
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(boundOperation)) continue;
            return operation;
        }
        return null;
    }

    @Check
    public void doNotAllowBODYMappingForGETsAndDELETEs(HTTPOperationBinding httpOperationBinding) {
        if (httpOperationBinding.getMethod() != HTTPVerb.GET && httpOperationBinding.getMethod() != HTTPVerb.DELETE) {
            return;
        }
        for (HTTPParameterBinding parameterBinding : EcoreUtil2.eAllOfType((EObject)httpOperationBinding, HTTPParameterBinding.class).stream().filter(pb -> pb.getParameterMapping() != null && pb.getParameterMapping() != null && pb.getParameterMapping() == HTTPParameter.BODY).collect(Collectors.toList())) {
            this.error("HTTP operations with the verbs GET and DELETE do not support BODY parameters.", parameterBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPParameterBinding_ParameterMapping());
        }
    }

    public void doNotAllowDifferentPATHBindingsInHTTPBinding(HTTPBinding httpBinding) {
        HashSet operationParameterBindings = Sets.newHashSet();
        if (httpBinding.getEb().size() == 0) {
            return;
        }
        for (HTTPOperationBinding operationBinding : ((HTTPResourceBinding)httpBinding.getEb().get(0)).getOpsB()) {
            Set params = operationBinding.getParameterBindings().stream().filter(pb -> pb.getParameterMapping() != null && pb.getParameterMapping() != null && pb.getParameterMapping() == HTTPParameter.PATH).map(pb -> pb.getBoundParameter()).collect(Collectors.toSet());
            if (params.isEmpty()) continue;
            operationParameterBindings.add(params);
        }
        if (operationParameterBindings.size() > 1) {
            this.error("This HTTP binding contains operations with different PATH parameter mappings. Please ensure that all operation map the same PATH parameters.", httpBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPBinding_Eb());
        }
    }
}

