/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class DataTypeValidator
extends AbstractMDSLValidator {
    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkRoleAndType(RoleAndType rat) {
        String role = rat.getRole();
        String basicType = rat.getBtype();
        if (basicType == null || basicType.equals("")) {
            this.info("Incomplete specification: No type such as <String> or <int> specified yet.", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (basicType.equals("void")) {
            this.info("Imprecise specification: <void> only makes sense as sole element of a response message; you might want to remove the empty message from the specification.", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("ID") && !basicType.equals("int") && !basicType.equals("string")) {
            this.warning("The role-type combination ID<" + basicType + "> is somewhat unusual. Use ID<string> or ID<int> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("L") && !basicType.equals("int") && !basicType.equals("string")) {
            this.warning("The role-type combination L<" + basicType + "> is somewhat unusual. Use L<string> or L<int> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("MD") && basicType.equals("raw")) {
            this.warning("The role-type combination MD<raw> is somewhat unusual. Use MD<string> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        }
    }

    @Check
    public void checkIncompleteTypeInformation(GenericParameter gp) {
        if (gp.getName() != null) {
            this.warning("\"" + gp.getName() + "\" is a generic parameter. You might want to provide a full identfier-role-type triple before invoking any generator.", gp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getGenericParameter_P());
        } else {
            this.warning("This is a generic parameter. You might want to provide a full identfier-role-type triple. See MDSL documentation at https://microservice-api-patterns.github.io/MDSL-Specification/datacontract.", gp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getGenericParameter_P());
        }
    }

    @Check
    public void checkParameterForestAsTuple(ParameterForest pf) {
        ArrayList<ParameterTree> trees = new ArrayList<ParameterTree>();
        trees.add(pf.getPtl().getFirst());
        trees.addAll((Collection<ParameterTree>)pf.getPtl().getNext());
        for (ParameterTree pt : trees) {
            if (pt.getName() == null) continue;
            this.info("ParameterForest are like tuples. Tuple items names are ignored.", pt, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getParameterTree_Name());
        }
    }
}

