/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.utils;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.CustomMediaType;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPParameterBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPTypeBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.MediaTypeList;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ReportBinding;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.StandardMediaType;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class MDSLSpecificationWrapper {
    private int logLevel = 1;
    private static final String DEFAULT_MEDIA_TYPE = "application/json";
    private ServiceSpecificationAdapter mdslSpecification;

    public MDSLSpecificationWrapper(ServiceSpecificationAdapter mdslSpecification) {
        this.mdslSpecification = mdslSpecification;
    }

    public ServiceSpecificationAdapter getSpecification() {
        return this.mdslSpecification;
    }

    public String getElementName(ElementStructure representationElement) {
        return "Default Element Name (Feature NYI)";
    }

    public boolean isAtomicOrIsFlatParameterTree(ElementStructure structure) {
        if (structure == null) {
            throw new MDSLException("Empty structure type (?)");
        }
        if (structure.getApl() != null) {
            return !this.isMultiplicity(structure.getApl().getCard());
        }
        if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            return !this.isMultiplicity(structure.getNp().getAtomP().getCard());
        }
        if (structure.getNp() != null && structure.getNp().getTr() != null) {
            if (this.isMultiplicity(structure.getNp().getTr().getCard())) {
                return false;
            }
            return this.isAtomicOrIsFlatParameterTree(structure.getNp().getTr().getDcref().getStructure());
        }
        if (structure.getPt() != null) {
            return this.isParameterTreeAtomic(structure.getPt());
        }
        return structure.getNp().getGenP() != null;
    }

    private boolean isMultiplicity(Cardinality card) {
        if (card == null) {
            return false;
        }
        return card.getAtLeastOne() != null || card.getZeroOrMore() != null;
    }

    public boolean isParameterTreeAtomic(ParameterTree tree) {
        if (this.isMultiplicity(tree.getCard())) {
            return false;
        }
        List<TreeNode> nodes = this.collectTreeNodes(tree);
        for (TreeNode node : nodes) {
            if (node.getPn() != null && node.getPn().getAtomP() != null || node.getApl() != null) continue;
            return false;
        }
        return true;
    }

    public boolean operationHasPayload(Operation mdslOperation) {
        return mdslOperation.getRequestMessage() != null && mdslOperation.getRequestMessage().getPayload() != null;
    }

    public boolean operationHasHeader(Operation mdslOperation) {
        return mdslOperation.getRequestMessage() != null && mdslOperation.getRequestMessage().getHeaders() != null;
    }

    public boolean operationHasReturnValue(Operation mdslOperation) {
        return mdslOperation.getResponseMessage() != null && mdslOperation.getResponseMessage().getPayload() != null;
    }

    public boolean operationHasReturnValueWithReports(Operation mdslOperation) {
        return mdslOperation.getResponseMessage() != null && mdslOperation.getResponseMessage().getPayload() != null && mdslOperation.getReports() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AtomicParameter> extractElements(ElementStructure structure) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
            return atomicParameterList;
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
            return atomicParameterList;
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                return this.extractElements(structure.getNp().getTr().getDcref().getStructure());
            }
            if (structure.getPt() != null) {
                if (!this.isParameterTreeAtomic(structure.getPt())) throw new MDSLException("Cannot extract atoms from nested tree '");
                atomicParameterList.addAll(this.collectAtomicParameters(structure.getPt()));
                return atomicParameterList;
            } else {
                if (structure.getNp().getGenP() == null) throw new MDSLException("Cannot extract from this type of element.");
                this.log("[W] Known limitation: Cannot handle a top-level generic parameter, skipping it: " + structure.getNp().getGenP().getName());
            }
        }
        return atomicParameterList;
    }

    public List<AtomicParameter> collectAtomicParameters(ParameterTree tree) {
        LinkedList list = Lists.newLinkedList();
        List<TreeNode> nodes = this.collectTreeNodes(tree);
        for (TreeNode node : nodes) {
            if (node.getPn() != null && node.getPn().getAtomP() != null) {
                list.add(node.getPn().getAtomP());
            }
            if (node.getApl() == null) continue;
            list.add(node.getApl().getFirst());
            list.addAll(node.getApl().getNextap());
        }
        return list;
    }

    private List<TreeNode> collectTreeNodes(ParameterTree tree) {
        LinkedList nodes = Lists.newLinkedList();
        nodes.add(tree.getFirst());
        nodes.addAll(tree.getNexttn());
        return nodes;
    }

    public List<EndpointInstance> findProviderEndpointInstancesFor(EndpointContract endpointType) {
        List endpoints = EcoreUtil2.eAllOfType((EObject)this.mdslSpecification, EndpointList.class);
        ArrayList<EndpointInstance> result = new ArrayList<EndpointInstance>();
        for (int i = 0; i < endpoints.size(); ++i) {
            EndpointList nextEndpointList = (EndpointList)endpoints.get(i);
            if (!nextEndpointList.getContract().getName().equals(endpointType.getName())) continue;
            EList<EndpointInstance> endpointInstances = nextEndpointList.getEndpoints();
            for (int j = 0; j < endpointInstances.size(); ++j) {
                EndpointInstance nextEndpoint = (EndpointInstance)endpointInstances.get(j);
                EList<TechnologyBinding> tbs = nextEndpoint.getPb();
                for (int k = 0; k < tbs.size(); ++k) {
                    TechnologyBinding tb = (TechnologyBinding)tbs.get(k);
                    if (tb.getProtBinding().getHttp() != null) {
                        result.add(nextEndpoint);
                        continue;
                    }
                    this.log("[EB] Non-HTTP binding found for " + nextEndpointList.getContract().getName());
                }
            }
        }
        return result;
    }

    public EndpointInstance findFirstAndOnlyHttpBindingIfExisting(EndpointContract endpointType) {
        List bindings = EcoreUtil2.eAllOfType((EObject)this.mdslSpecification, TechnologyBinding.class);
        List httpBindings = bindings.stream().filter(b -> b.getProtBinding() != null && b.getProtBinding().getHttp() != null && b.getProtBinding().getHttp() instanceof HTTPBinding).collect(Collectors.toList());
        if (httpBindings.size() == 1) {
            return (EndpointInstance)((TechnologyBinding)httpBindings.get(0)).eContainer();
        }
        return null;
    }

    public HTTPVerb findVerbBindingFor(String operation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = this.findOperationBindingFor(operation, binding);
        if (opB != null) {
            return opB.getMethod();
        }
        return null;
    }

    public HTTPTypeBinding findLinkTypeBindingFor(String name, HTTPResourceBinding binding) {
        EList<HTTPTypeBinding> tps = binding.getTB();
        for (HTTPTypeBinding tb : tps) {
            if (tb.getLt() == null || !tb.getLt().getName().equals(name)) continue;
            return tb;
        }
        return null;
    }

    public HTTPOperationBinding findOperationBindingFor(String operation, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            return opB;
        }
        return null;
    }

    public HTTPParameter findParameterBindingFor(String operation, String parameter, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        HTTPOperationBinding opB = this.findOperationBindingFor(operation, binding);
        if (opB == null) {
            return null;
        }
        if (opB.getGlobalBinding() != null) {
            this.log("[P] Found a global parameter mapping in " + operation);
            return opB.getGlobalBinding().getParameterMapping();
        }
        EList<HTTPParameterBinding> parameterBindings = opB.getParameterBindings();
        for (int i = 0; i < parameterBindings.size(); ++i) {
            HTTPParameterBinding pB = (HTTPParameterBinding)parameterBindings.get(i);
            if (!pB.getBoundParameter().equals(parameter)) continue;
            this.log("[P] Found a parameter binding for " + operation + " in " + binding.getName());
            return pB.getParameterMapping();
        }
        this.log("[P] No parameter binding found for " + parameter + " in " + binding.getName());
        return null;
    }

    public String findReportCodeInBinding(String operation, String reportNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return "x-742";
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            this.logInformation("Found an operation binding for " + operation + " in " + binding.getName() + ": " + opB.getMethod().getName());
            EList<ReportBinding> reports = opB.getReportBindings();
            for (int j = 0; j < reports.size(); ++j) {
                ReportBinding report = (ReportBinding)reports.get(j);
                this.logInformation("Processing a report binding: " + report.getName());
                if (!report.getName().equals(reportNameInEndpointType)) continue;
                this.logInformation("Report binding found for " + operation + " in " + binding.getName());
                return String.valueOf(report.getHttpStatusCode());
            }
        }
        this.log("[W] No report binding found for " + operation + " in " + binding.getName());
        return "x-743";
    }

    public String findReportTextInBinding(String operation, String reportNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return "null";
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            this.log("[OB] Found an operation binding for " + operation + " in " + binding.getName() + ": " + opB.getMethod().getName());
            EList<ReportBinding> reports = opB.getReportBindings();
            for (int j = 0; j < reports.size(); ++j) {
                ReportBinding report = (ReportBinding)reports.get(j);
                if (!report.getName().equals(reportNameInEndpointType)) continue;
                this.log("[RB] Report binding found for " + operation + " in " + binding.getName());
                return report.getDetails();
            }
        }
        this.logWarning("No report binding found for " + operation + " in " + binding.getName());
        return "n/a";
    }

    public SecurityBinding findPolicyInBinding(String operation, String policyNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            EList<SecurityBinding> policies = opB.getSecurityBindings();
            for (int j = 0; j < policies.size(); ++j) {
                SecurityBinding policy = (SecurityBinding)policies.get(j);
                if (!policy.getName().equals(policyNameInEndpointType)) continue;
                this.log("[PB] Policy binding found for " + operation + " in " + binding.getName());
                return policy;
            }
        }
        this.logWarning("No policy binding found for " + operation + " in " + binding.getName() + ", skipping this one.");
        return null;
    }

    public List<String> findMediaTypeForRequest(Operation mdslOperation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = this.findOperationBindingFor(mdslOperation.getName(), binding);
        if (opB == null || opB.getInContentTypes() == null) {
            ArrayList<String> defaultTypeList = new ArrayList<String>();
            defaultTypeList.add(DEFAULT_MEDIA_TYPE);
            return defaultTypeList;
        }
        return this.findMediaTypes(opB.getInContentTypes());
    }

    public List<String> findMediaTypeForResponse(Operation mdslOperation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = this.findOperationBindingFor(mdslOperation.getName(), binding);
        if (opB == null || opB.getOutContentTypes() == null) {
            ArrayList<String> defaultTypeList = new ArrayList<String>();
            defaultTypeList.add(DEFAULT_MEDIA_TYPE);
            return defaultTypeList;
        }
        return this.findMediaTypes(opB.getOutContentTypes());
    }

    private List<String> findMediaTypes(MediaTypeList mimeTypes) {
        EList<StandardMediaType> smtl;
        EList<CustomMediaType> cmtl;
        ArrayList<String> result = new ArrayList<String>();
        if (mimeTypes.getCmt() != null && (cmtl = mimeTypes.getCmt()) != null) {
            cmtl.forEach(cmt -> result.add(cmt.getValue()));
        }
        if (mimeTypes.getSmt() != null && (smtl = mimeTypes.getSmt()) != null && smtl.size() > 0) {
            smtl.forEach(smt -> result.add(smt.getIanaName()));
        }
        return result;
    }

    private String findKVPInPolicy(SecurityBinding spb, String key) {
        EList<String> keys = spb.getKeys();
        EList<String> values = spb.getValues();
        if (keys.contains((Object)key)) {
            int aurlPos = keys.indexOf((Object)key);
            return (String)values.get(aurlPos);
        }
        return null;
    }

    public String findAuthorizationUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, "authorizationUrl");
    }

    public String findTokenUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, "tokenUrl");
    }

    public String findOIDUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, "openIdConnectUrl");
    }

    public Map<String, String> findScopesInPolicyOrBinding(SecurityPolicy sp, SecurityBinding spb) {
        HashMap<String, String> result = new HashMap<String, String>();
        EList<String> keys = spb.getKeys();
        EList<String> values = spb.getValues();
        for (int i = 0; i < keys.size(); ++i) {
            if (!((String)keys.get(i)).startsWith("Scope")) continue;
            result.put((String)keys.get(i), (String)values.get(i));
        }
        return result;
    }

    public void logError(String string) {
        if (this.logLevel >= 0) {
            System.err.println("[E] " + string);
        }
    }

    public void logWarning(String string) {
        if (this.logLevel >= 1) {
            this.log("[W] " + string);
        }
    }

    public void logInformation(String string) {
        if (this.logLevel >= 2) {
            this.log("[I] " + string);
        }
    }

    public void log(String string) {
        System.out.println(string);
    }
}

