/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.protobuf.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.microserviceapipatterns.protobufgen.model.AnyType;
import io.github.microserviceapipatterns.protobufgen.model.FieldType;
import io.github.microserviceapipatterns.protobufgen.model.Message;
import io.github.microserviceapipatterns.protobufgen.model.MessageField;
import io.github.microserviceapipatterns.protobufgen.model.ProtoSpec;
import io.github.microserviceapipatterns.protobufgen.model.SimpleFieldType;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.generator.AnonymousFieldNameGenerator;
import io.mdsl.generator.CardinalityHelper;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;

public class DataType2MessageConverter {
    private static final FieldType FALLBACK_PRIMITIVE_TYPE = new AnyType();
    private ProtoSpec.Builder protoSpec;
    private AnonymousFieldNameGenerator fieldNameGenerator;
    private Message unspecifiedTypeMessage;
    private Set<String> generatedTypeNames;

    public DataType2MessageConverter(ProtoSpec.Builder protoSpec) {
        this.protoSpec = protoSpec;
        this.fieldNameGenerator = new AnonymousFieldNameGenerator();
        this.generatedTypeNames = Sets.newHashSet();
    }

    public Message convert(DataContract contract) {
        Message.Builder message = new Message.Builder(contract.getName());
        this.mapElementStructure(contract.getStructure(), message);
        return message.build();
    }

    public void mapElementStructure(ElementStructure elementStructure, Message.Builder message) {
        if (elementStructure.getPf() != null) {
            this.mapParameterForest(elementStructure.getPf(), message);
        } else if (elementStructure.getPt() != null) {
            this.mapParameterTree(elementStructure.getPt(), message);
        } else if (elementStructure.getApl() != null) {
            this.mapAtomicParameterList(elementStructure.getApl(), message);
        } else {
            this.mapSingleParameterNode(elementStructure.getNp(), message);
        }
    }

    private void mapParameterForest(ParameterForest pf, Message.Builder message) {
        LinkedList trees = Lists.newLinkedList();
        trees.add(pf.getPtl().getFirst());
        trees.addAll(pf.getPtl().getNext());
        for (ParameterTree tree : trees) {
            String attrName = this.fieldNameGenerator.getUniqueName(tree.getName());
            String typeName = this.deriveMessageNameFromParameterName(attrName);
            Message.Builder nestedMessageBuilder = new Message.Builder(typeName);
            this.mapParameterTree(tree, nestedMessageBuilder);
            Message nestedMessage = nestedMessageBuilder.build();
            message.withNestedMessage(nestedMessage);
            MessageField.Builder field = new MessageField.Builder((FieldType)nestedMessage, attrName, this.getNextFieldNumber(message));
            this.addField2Message(message, field, tree.getCard());
        }
    }

    private void mapParameterTree(ParameterTree pt, Message.Builder message) {
        LinkedList treeNodes = Lists.newLinkedList();
        treeNodes.add(pt.getFirst());
        treeNodes.addAll(pt.getNexttn());
        for (TreeNode treeNode : treeNodes) {
            this.mapTreeNode(treeNode, message);
        }
    }

    private void mapTreeNode(TreeNode treeNode, Message.Builder message) {
        if (treeNode.getPn() != null && treeNode.getPn().getGenP() != null) {
            message.withField((FieldType)this.getUnspecifiedTypeMessage(), this.fieldNameGenerator.getUniqueName(treeNode.getPn().getGenP().getName()));
        } else if (treeNode.getPn() != null) {
            this.mapSingleParameterNode(treeNode.getPn(), message);
        } else if (treeNode.getApl() != null) {
            AtomicParameterList list = treeNode.getApl();
            String attrName = this.fieldNameGenerator.getUniqueName(list.getName());
            String typeName = this.deriveMessageNameFromParameterName(attrName);
            Message.Builder nestedMessageBuilder = new Message.Builder(typeName);
            this.mapAtomicParameterList(list, nestedMessageBuilder);
            Message nestedMessage = nestedMessageBuilder.build();
            message.withNestedMessage(nestedMessage);
            MessageField.Builder field = new MessageField.Builder((FieldType)nestedMessage, attrName, this.getNextFieldNumber(message));
            this.addField2Message(message, field, list.getCard());
        } else if (treeNode.getChildren() != null) {
            ParameterTree subTree = treeNode.getChildren();
            String attrName = this.fieldNameGenerator.getUniqueName(subTree.getName());
            String typeName = this.deriveMessageNameFromParameterName(attrName);
            Message.Builder nestedMessageBuilder = new Message.Builder(typeName);
            this.mapParameterTree(subTree, nestedMessageBuilder);
            Message nestedMessage = nestedMessageBuilder.build();
            message.withNestedMessage(nestedMessage);
            MessageField.Builder field = new MessageField.Builder((FieldType)nestedMessage, attrName, this.getNextFieldNumber(message));
            this.addField2Message(message, field, subTree.getCard());
        }
    }

    private void mapAtomicParameterList(AtomicParameterList apl, Message.Builder message) {
        LinkedList<AtomicParameter> parameters = new LinkedList<AtomicParameter>();
        parameters.add(apl.getFirst());
        parameters.addAll((Collection<AtomicParameter>)apl.getNextap());
        for (AtomicParameter ap : parameters) {
            MessageField.Builder field = new MessageField.Builder(this.mapBasicType(ap.getRat().getBtype()), this.fieldNameGenerator.getUniqueName(ap.getRat().getName()), this.getNextFieldNumber(message));
            this.addField2Message(message, field, ap.getCard());
        }
    }

    private void mapSingleParameterNode(SingleParameterNode spn, Message.Builder message) {
        if (spn.getAtomP() != null) {
            MessageField.Builder field = new MessageField.Builder(this.mapBasicType(spn.getAtomP().getRat().getBtype()), this.fieldNameGenerator.getUniqueName(spn.getAtomP().getRat().getName()), this.getNextFieldNumber(message));
            this.addField2Message(message, field, spn.getAtomP().getCard());
        } else if (spn.getTr() != null) {
            String attrName = this.fieldNameGenerator.getUniqueName(spn.getTr().getName());
            MessageField.Builder field = new MessageField.Builder((FieldType)this.convert(spn.getTr().getDcref()), attrName, this.getNextFieldNumber(message));
            this.addField2Message(message, field, spn.getTr().getCard());
        } else if (spn.getGenP() != null) {
            // empty if block
        }
    }

    private Message getUnspecifiedTypeMessage() {
        if (this.unspecifiedTypeMessage == null) {
            this.unspecifiedTypeMessage = new Message.Builder("UnspecifiedType").build();
            this.protoSpec.withMessage(this.unspecifiedTypeMessage);
        }
        return this.unspecifiedTypeMessage;
    }

    private String deriveMessageNameFromParameterName(String parameterName) {
        String notNullOrEmptyName = this.fieldNameGenerator.getUniqueName(parameterName);
        String derivedName = notNullOrEmptyName.substring(0, 1).toUpperCase() + notNullOrEmptyName.substring(1) + "Message";
        if (this.generatedTypeNames.contains(derivedName)) {
            String baseName = derivedName;
            int counter = 2;
            while (this.generatedTypeNames.contains(derivedName)) {
                derivedName = baseName + "_" + counter;
                ++counter;
            }
        }
        this.generatedTypeNames.add(derivedName);
        return derivedName;
    }

    private FieldType mapBasicType(String mdslType) {
        if (mdslType == null) {
            return FALLBACK_PRIMITIVE_TYPE;
        }
        switch (mdslType) {
            case "bool": {
                return SimpleFieldType.BOOL;
            }
            case "int": {
                return SimpleFieldType.INT32;
            }
            case "long": {
                return SimpleFieldType.INT64;
            }
            case "double": {
                return SimpleFieldType.DOUBLE;
            }
            case "string": {
                return SimpleFieldType.STRING;
            }
            case "raw": {
                return SimpleFieldType.BYTES;
            }
        }
        return FALLBACK_PRIMITIVE_TYPE;
    }

    private void addField2Message(Message.Builder message, MessageField.Builder field, Cardinality card) {
        if (CardinalityHelper.isList(card)) {
            message.withField(field.repeated().build());
        } else if (CardinalityHelper.isOptional(card)) {
            message.withField(field).withField((FieldType)SimpleFieldType.BOOL, "has_" + field.build().getName()).build();
        } else {
            message.withField(field.build());
        }
    }

    private int getNextFieldNumber(Message.Builder message) {
        return message.build().getFields().size() + 1;
    }
}

