/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.openapi.converter.DataType2SchemaConverter;
import io.mdsl.generator.openapi.converter.Endpoint2PathConverter;
import io.mdsl.utils.MAPLinkResolver;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.mdsl.utils.URITemplateHelper;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class MDSL2OpenAPIConverter {
    private static final String DEFAULT_VERSION = "1.0";
    private ServiceSpecificationAdapter mdslSpecification;
    private MDSLSpecificationWrapper mdslWrapper;
    private Map<String, SecurityScheme> securitySchemes;
    private List<Server> servers;

    public MDSL2OpenAPIConverter(ServiceSpecification mdslSpecification) {
        this.mdslSpecification = new ServiceSpecificationAdapter(mdslSpecification);
        this.mdslWrapper = new MDSLSpecificationWrapper(this.mdslSpecification);
        this.securitySchemes = new HashMap<String, SecurityScheme>();
        this.servers = new ArrayList<Server>();
    }

    public OpenAPI convert() {
        OpenAPI oas = new OpenAPI();
        oas.setInfo(new Info().title(this.mdslSpecification.getName()).version(this.getAPIVersion()));
        oas.setPaths(this.convertEndpoints2Paths());
        oas.setComponents(this.createComponents());
        oas.getComponents().setSchemas(this.convertDataTypes2Schemas());
        oas.setTags(this.createTagsViaEndpointInstanceAndItsResources());
        oas.servers(this.servers);
        if (!this.securitySchemes.isEmpty()) {
            oas.getComponents().securitySchemes(this.securitySchemes);
        }
        return oas;
    }

    private Components createComponents() {
        return new Components();
    }

    private String getAPIVersion() {
        return this.mdslSpecification.getSvi() != null && !"".equals(this.mdslSpecification.getSvi()) ? this.mdslSpecification.getSvi() : DEFAULT_VERSION;
    }

    private List<Tag> createTagsViaEndpointInstanceAndItsResources() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        boolean foundAtLeastOneBinding = false;
        for (HTTPResourceBinding resourceBinding : EcoreUtil2.eAllOfType((EObject)this.mdslSpecification, HTTPResourceBinding.class)) {
            Tag tag = this.createTag(null, resourceBinding, true);
            tags.add(tag);
            foundAtLeastOneBinding = true;
        }
        if (!foundAtLeastOneBinding) {
            return this.createTagsViaEndpointType();
        }
        return tags;
    }

    public Tag createTag(EndpointContract endpointType, HTTPResourceBinding resourceBinding, boolean createExternalDescription) {
        Tag tag = new Tag();
        if (resourceBinding != null) {
            EndpointInstance ei = this.getContainingEndpointInstance(resourceBinding);
            EndpointList eil = (EndpointList)ei.eContainer();
            Provider provider = (Provider)eil.eContainer();
            tag.setName(provider.getName() + "-" + resourceBinding.getName());
            String contractName = eil.getContract().getName();
            if (createExternalDescription) {
                ExternalDocumentation externalDocs = new ExternalDocumentation();
                externalDocs.setDescription("The role of this endpoint, offering a " + contractName + " contract, is " + MAPLinkResolver.provideMAP(eil.getContract()));
                externalDocs.setUrl(MAPLinkResolver.provideLinktoMAPWebsite(eil.getContract()));
                tag.setExternalDocs(externalDocs);
            }
        } else if (endpointType != null) {
            tag.setName(endpointType.getName());
            if (createExternalDescription) {
                ExternalDocumentation externalDocs = new ExternalDocumentation();
                externalDocs.setDescription("The role of this endpoint, offering a " + endpointType.getName() + " contract, is " + MAPLinkResolver.provideMAP(endpointType));
                externalDocs.setUrl(MAPLinkResolver.provideLinktoMAPWebsite(endpointType));
                tag.setExternalDocs(externalDocs);
            }
        } else {
            throw new MDSLException("Either a contract name or a resource binding name must be present.");
        }
        return tag;
    }

    public EndpointInstance getContainingEndpointInstance(HTTPResourceBinding resourceBinding) {
        EObject rbc = resourceBinding.eContainer();
        EObject eic = rbc.eContainer().eContainer().eContainer();
        return (EndpointInstance)eic;
    }

    private List<Tag> createTagsViaEndpointType() {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (EndpointContract endpointType : this.mdslSpecification.getEndpointContracts()) {
            Tag tag = new Tag();
            tag.setName(endpointType.getName());
            ExternalDocumentation externalDocs = new ExternalDocumentation();
            externalDocs.setDescription("The role of this endpoint is " + MAPLinkResolver.provideMAP(endpointType));
            externalDocs.setUrl(MAPLinkResolver.provideLinktoMAPWebsite(endpointType));
            tag.setExternalDocs(externalDocs);
            tags.add(tag);
        }
        return tags;
    }

    public SecurityScheme convertPolicy2SecurityScheme(SecurityPolicy sp, SecurityBinding secBinding) {
        SecurityScheme ss = null;
        if (sp == null) {
            throw new MDSLException("Can't bind an empty security policy");
        }
        ElementStructure spo = sp.getSecurityObject();
        if (secBinding == null) {
            this.mdslWrapper.logWarning("Skipping empty binding");
            return null;
        }
        if (secBinding.getHttp() == null) {
            throw new MDSLException("Security binding policy: expected something from getHttp" + sp.getName());
        }
        if (secBinding.getHttp().getValue() == 0) {
            ss = new SecurityScheme().type(SecurityScheme.Type.HTTP);
            ss.scheme("basic");
            this.securitySchemes.put(sp.getName(), ss);
        } else if (secBinding.getHttp().getValue() == 1) {
            ss = new SecurityScheme().type(SecurityScheme.Type.HTTP);
            ss.scheme("bearer");
            ss.bearerFormat("JWT");
            this.securitySchemes.put(sp.getName(), ss);
        } else if (secBinding.getHttp().getValue() == 2) {
            ss = new SecurityScheme().type(SecurityScheme.Type.APIKEY);
            ss.in(SecurityScheme.In.HEADER);
            ss.name("api_key");
            this.securitySchemes.put(sp.getName(), ss);
        } else if (secBinding.getHttp().getValue() == 3) {
            ss = new SecurityScheme().type(SecurityScheme.Type.OAUTH2);
            OAuthFlows flows = new OAuthFlows();
            Map<String, String> scopesMap = this.mdslWrapper.findScopesInPolicyOrBinding(sp, secBinding);
            Scopes scopes = new Scopes();
            scopesMap.forEach((skey, svalue) -> scopes.addString(skey, svalue));
            OAuthFlow implicitOAuthObject = new OAuthFlow();
            implicitOAuthObject.authorizationUrl(this.mdslWrapper.findAuthorizationUrlInPolicy(secBinding));
            implicitOAuthObject.scopes(scopes);
            flows.implicit(implicitOAuthObject);
            OAuthFlow authorizationCode = new OAuthFlow();
            authorizationCode.authorizationUrl(this.mdslWrapper.findAuthorizationUrlInPolicy(secBinding));
            authorizationCode.tokenUrl(this.mdslWrapper.findTokenUrlInPolicy(secBinding));
            authorizationCode.scopes(scopes);
            flows.authorizationCode(authorizationCode);
            ss.flows(flows);
            this.securitySchemes.put(sp.getName(), ss);
        } else if (secBinding.getHttp().getValue() == 4) {
            ss = new SecurityScheme().type(SecurityScheme.Type.OPENIDCONNECT);
            ss.openIdConnectUrl(this.mdslWrapper.findOIDUrlInPolicy(secBinding));
            this.securitySchemes.put(sp.getName(), ss);
        } else {
            this.mdslWrapper.logError("Unknown security type" + secBinding.getHttp().getValue());
        }
        if (ss != null) {
            String id = this.mdslWrapper.getElementName(spo);
            ss.description(id);
        }
        return ss;
    }

    private Paths convertEndpoints2Paths() {
        Paths paths = new Paths();
        Endpoint2PathConverter pathsConverter = new Endpoint2PathConverter(this.mdslSpecification, this);
        for (EndpointContract endpointType : this.mdslSpecification.getEndpointContracts()) {
            List<EndpointInstance> endpointInstanceList = this.mdslWrapper.findProviderEndpointInstancesFor(endpointType);
            this.mdslWrapper.logInformation("Endpoint type " + endpointType.getName() + " has " + endpointInstanceList.size() + " HTTP binding(s).");
            if (endpointInstanceList.size() == 0) {
                this.mdslWrapper.logWarning("No endpoint instance/provider in " + endpointType.getName());
                String pathURI = "/" + endpointType.getName();
                PathItem mappedEndpoint = pathsConverter.convertMetadataAndOperations(endpointType, null);
                paths.addPathItem(pathURI, mappedEndpoint);
                continue;
            }
            for (int i = 0; i < endpointInstanceList.size(); ++i) {
                String pathURI;
                Parameter pp = null;
                Server server = new Server().url(endpointInstanceList.get(i).getName());
                this.servers.add(server);
                if (endpointInstanceList.get(i).getName().startsWith("/")) {
                    this.mdslWrapper.logInformation("Next endpoint instance: " + endpointInstanceList.get(i).getName());
                    pathURI = endpointInstanceList.get(i).getName();
                    List<String> templates = URITemplateHelper.findTemplateParameters(pathURI);
                    if (templates.size() > 0) {
                        this.mdslWrapper.logWarning("Found one or more URI template parameters on endpoint level, not mapped.");
                    }
                } else {
                    this.mdslWrapper.logWarning("Endpoint instance location should start with '/', added.");
                    pathURI = "/" + endpointInstanceList.get(i).getName();
                }
                EList<HTTPResourceBinding> bindings = this.getHTTPResourceBindings(endpointInstanceList.get(i));
                if (bindings.size() == 0) {
                    this.mdslWrapper.logWarning("No HTTP binding found for " + endpointType.getName());
                    PathItem mappedEndpoint = pathsConverter.convertMetadataAndOperations(endpointType, null);
                    paths.addPathItem(pathURI, mappedEndpoint);
                    continue;
                }
                for (int j = 0; j < bindings.size(); ++j) {
                    String relURI = "";
                    HTTPResourceBinding binding = (HTTPResourceBinding)bindings.get(j);
                    if (binding.getUri() != null) {
                        if (binding.getUri().startsWith("/")) {
                            relURI = binding.getUri();
                        } else {
                            this.mdslWrapper.logWarning("Relative URI should start with '/', adding it.");
                            relURI = "/" + binding.getUri();
                        }
                    }
                    PathItem mappedEndpoint = pathsConverter.convertMetadataAndOperations(endpointType, binding);
                    List<String> templates = URITemplateHelper.findTemplateParameters(relURI);
                    if (templates != null) {
                        for (int k = 0; k < templates.size(); ++k) {
                            pp = new Parameter();
                            String template = templates.get(k);
                            pp.name(template.substring(1, template.length() - 1));
                            pp.in("path");
                            pp.schema(new Schema().type("string"));
                            mappedEndpoint.addParametersItem(pp);
                        }
                    } else {
                        this.mdslWrapper.logInformation("No URI template parameters in resource URI: " + relURI);
                    }
                    paths.addPathItem(pathURI + relURI, mappedEndpoint);
                }
            }
        }
        return paths;
    }

    private Map<String, Schema> convertDataTypes2Schemas() {
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        DataType2SchemaConverter typesConverter = new DataType2SchemaConverter();
        for (DataContract dataType : this.mdslSpecification.getTypes()) {
            map.put(dataType.getName(), typesConverter.convert(dataType));
        }
        return map;
    }

    private EList<HTTPResourceBinding> getHTTPResourceBindings(EndpointInstance endpointInstance) {
        EList<TechnologyBinding> protocolBindings = endpointInstance.getPb();
        for (int i = 0; i < protocolBindings.size(); ++i) {
            ProtocolBinding pb = ((TechnologyBinding)endpointInstance.getPb().get(i)).getProtBinding();
            HTTPBinding httpb = pb.getHttp();
            if (httpb == null) continue;
            EList<HTTPResourceBinding> httprb = httpb.getEb();
            if (httprb == null) {
                return null;
            }
            return httprb;
        }
        return null;
    }
}

