/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPTypeBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.LinkContract;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RelationshipLink;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.openapi.converter.DataType2ParameterConverter;
import io.mdsl.generator.openapi.converter.DataType2SchemaConverter;
import io.mdsl.generator.openapi.converter.MDSL2OpenAPIConverter;
import io.mdsl.utils.MAPLinkResolver;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class Endpoint2PathConverter {
    private static final String DEFAULT_RESPONSE_NAME = "200";
    private DataType2SchemaConverter dataType2SchemaConverter = new DataType2SchemaConverter();
    private DataType2ParameterConverter dataType2ParameterConverter;
    private MDSL2OpenAPIConverter mdsl2OpenAPIConverter;
    private MDSLSpecificationWrapper mdslWrapper;

    public Endpoint2PathConverter(ServiceSpecificationAdapter apiDescriptionToBeConverted, MDSL2OpenAPIConverter mdsl2OpenAPIConverter) {
        this.dataType2ParameterConverter = new DataType2ParameterConverter(apiDescriptionToBeConverted);
        this.mdslWrapper = new MDSLSpecificationWrapper(apiDescriptionToBeConverted);
        this.mdsl2OpenAPIConverter = mdsl2OpenAPIConverter;
    }

    public PathItem convertMetadataAndOperations(EndpointContract endpointType, HTTPResourceBinding binding) {
        PathItem pathItemForResource = new PathItem();
        pathItemForResource.setSummary(MAPLinkResolver.explainRolePattern(endpointType));
        HashMap<PathItem.HttpMethod, String> alreadyUsedVerbs = new HashMap<PathItem.HttpMethod, String>();
        if (binding == null) {
            for (io.mdsl.apiDescription.Operation operation : endpointType.getOps()) {
                PathItem.HttpMethod verb = this.mapMethod(operation, binding);
                if (alreadyUsedVerbs.containsKey(verb)) {
                    throw new MDSLException("Mapping conflict in default resource  (" + operation.getName() + "): operation " + (String)alreadyUsedVerbs.get(verb) + " already maps to " + verb.toString() + ". Start operation names with 'create', 'read', 'update', 'delete', add decorators (MAP responsibilities or HTTP verbs) or bind to mulitple resources.");
                }
                alreadyUsedVerbs.put(verb, operation.getName());
                pathItemForResource.operation(verb, this.convertOperation(endpointType, operation, verb, binding));
            }
        } else {
            for (io.mdsl.apiDescription.Operation operation : endpointType.getOps()) {
                HTTPOperationBinding opb = this.mdslWrapper.findOperationBindingFor(operation.getName(), binding);
                if (opb == null) {
                    this.mdslWrapper.logWarning("Operation *not* bound in resource " + binding.getName() + " " + operation.getName());
                    continue;
                }
                this.mdslWrapper.logInformation("Operation bound in this resource:" + binding.getName() + " " + operation.getName());
                PathItem.HttpMethod verb = this.mapMethod(operation, binding);
                if (alreadyUsedVerbs.containsKey(verb)) {
                    throw new MDSLException("Mapping conflict in resource " + binding.getName() + " (" + operation.getName() + "): operation " + (String)alreadyUsedVerbs.get(verb) + " already maps to " + verb.toString() + ". Start operation names with 'create', 'read', 'update', 'delete', add decorators (MAP responsibilities or HTTP verbs) or bind to mulitple resources.");
                }
                alreadyUsedVerbs.put(verb, operation.getName());
                pathItemForResource.operation(verb, this.convertOperation(endpointType, operation, verb, binding));
            }
        }
        return pathItemForResource;
    }

    private Operation convertOperation(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding) {
        Operation operation = new Operation();
        if (binding != null) {
            operation.setOperationId(binding.getName() + '-' + mdslOperation.getName());
        } else {
            operation.setOperationId(mdslOperation.getName());
        }
        operation.setSummary(MAPLinkResolver.explainResponsibilityPattern(mdslOperation));
        operation.setDescription(MAPLinkResolver.provideLinktoMAPWebsite(mdslOperation));
        ArrayList<String> tags = new ArrayList<String>();
        Tag rtag = this.mdsl2OpenAPIConverter.createTag(endpointType, binding, false);
        tags.add(rtag.getName());
        operation.setTags(tags);
        this.handleRequestMessage(endpointType, mdslOperation, verb, binding, operation);
        this.handleResponseMessages(mdslOperation, binding, operation);
        List<SecurityRequirement> securityRequrementList = this.handleSecurity(endpointType, mdslOperation, binding);
        if (securityRequrementList != null) {
            securityRequrementList.forEach(requirement -> operation.addSecurityItem(requirement));
        }
        return operation;
    }

    private void handleHeaders(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding, Operation operation, List<Parameter> parameterList) {
        ElementStructure headers = mdslOperation.getRequestMessage().getHeaders();
        if (headers == null) {
            return;
        }
        this.convertSingleRepresentationElement(endpointType, mdslOperation, verb, binding, operation, HTTPParameter.HEADER, parameterList, headers, null);
    }

    private void handleRequestMessage(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding, Operation operation) {
        HTTPParameter boundParameter = HTTPParameter.BODY;
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        if (this.mdslWrapper.operationHasHeader(mdslOperation)) {
            this.handleHeaders(endpointType, mdslOperation, verb, binding, operation, parameterList);
        }
        if (this.mdslWrapper.operationHasPayload(mdslOperation)) {
            this.mdslWrapper.logInformation("Mapping payload of operation: " + mdslOperation.getName());
            ElementStructure operationPayload = mdslOperation.getRequestMessage().getPayload();
            List<String> mediaTypes = this.mdslWrapper.findMediaTypeForRequest(mdslOperation, binding);
            this.convertSingleRepresentationElement(endpointType, mdslOperation, verb, binding, operation, boundParameter, parameterList, operationPayload, mediaTypes);
        }
    }

    private void convertSingleRepresentationElement(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding, Operation operation, HTTPParameter boundParameter, List<Parameter> parameterList, ElementStructure operationPayload, List<String> mediaTypes) {
        if (operationPayload != null && this.mdslWrapper.isAtomicOrIsFlatParameterTree(operationPayload)) {
            this.mdslWrapper.logInformation(" has atomic parameters only (or a flat tree element structure).");
            this.handleSimplePayload(endpointType, mdslOperation, verb, binding, operation, parameterList, operationPayload, mediaTypes);
        } else if (operationPayload != null) {
            this.mdslWrapper.logInformation("This is a nested parameter tree or forest (or flat one with '*' or '+' cardinality).");
            this.handleComplexPayload(mdslOperation, verb, binding, operation, boundParameter, operationPayload, mediaTypes, false);
        } else {
            this.mdslWrapper.logWarning("Empty or unsupported request payload structure in " + mdslOperation.getName());
        }
    }

    private void handleSimplePayload(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding, Operation operation, List<Parameter> parameterList, ElementStructure operationPayload, List<String> mediaTypes) {
        HTTPParameter boundParameter = this.defaultBindingFor(verb);
        List<AtomicParameter> apsInOp = this.mdslWrapper.extractElements(operationPayload);
        for (int i = 0; i < apsInOp.size(); ++i) {
            AtomicParameter nextParameter = apsInOp.get(i);
            if (nextParameter.getRat().getName() == null) {
                boundParameter = this.defaultBindingFor(verb);
                this.mdslWrapper.logInformation("(" + verb.name() + "): anonymous parameter bound to: " + boundParameter.getLiteral());
            } else {
                boundParameter = this.mdslWrapper.findParameterBindingFor(mdslOperation.getName(), nextParameter.getRat().getName(), binding);
                if (boundParameter != null) {
                    this.mdslWrapper.logInformation("(" + verb.name() + "): " + nextParameter.getRat().getName() + " bound to: " + boundParameter.getLiteral());
                } else {
                    boundParameter = this.defaultBindingFor(verb);
                }
            }
            if (boundParameter.equals((Object)HTTPParameter.BODY)) {
                if (!this.verbIsAllowedToHaveRequestBody(verb)) {
                    throw new MDSLException("Unsupported verb-parameterType combination: " + verb.name() + " and " + boundParameter.getLiteral() + " cannot be used together.");
                }
                operation.requestBody(this.createRequestBody(mdslOperation.getRequestMessage().getPayload(), mediaTypes));
                continue;
            }
            List<Parameter> pl = this.dataType2ParameterConverter.convertSingleRepresentationElementToOneParameter(nextParameter, verb, boundParameter);
            parameterList.addAll(pl);
        }
        operation.parameters(parameterList);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleComplexPayload(io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod verb, HTTPResourceBinding binding, Operation operation, HTTPParameter boundParameter, ElementStructure operationPayload, List<String> mediaTypes, boolean externalCardinality) {
        if (operationPayload.getPt() != null) {
            String tname = operationPayload.getPt().getName();
            if (this.treeHasMultiplicity(operationPayload.getPt())) {
                externalCardinality = true;
            }
            if ((boundParameter = this.mdslWrapper.findParameterBindingFor(mdslOperation.getName(), tname, binding)) == null) {
                boundParameter = HTTPParameter.BODY;
            }
            if (boundParameter == HTTPParameter.BODY) {
                if (!this.verbIsAllowedToHaveRequestBody(verb)) throw new MDSLException("Unsupported HTTPVerb-HTTPParameterType combination in " + mdslOperation.getName() + ": " + verb.name() + " and " + boundParameter.getLiteral() + " cannot be used together.");
                operation.requestBody(this.createRequestBody(mdslOperation.getRequestMessage().getPayload(), mediaTypes));
                return;
            } else {
                Parameter parameter = this.dataType2ParameterConverter.convertTree(operationPayload.getPt(), verb, boundParameter, externalCardinality);
                operation.addParametersItem(parameter);
            }
            return;
        } else if (operationPayload.getPf() != null) {
            this.mdslWrapper.logWarning(verb.name() + "): parameter forest bound to body");
            if (!this.verbIsAllowedToHaveRequestBody(verb)) {
                throw new MDSLException("Known limitation: Parameter Forests can only be mapped to BODY at present, which is not possible for " + verb);
            }
            operation.requestBody(this.createRequestBody(mdslOperation.getRequestMessage().getPayload(), mediaTypes));
            return;
        } else if (operationPayload.getNp().getTr() != null) {
            TypeReference referencedType = operationPayload.getNp().getTr();
            if (referencedType == null || referencedType.getDcref() == null) {
                throw new MDSLException("Type reference does not point at valid element structure (data type).");
            }
            boolean extCard = false;
            if (this.referenceHasMultiplicity(operationPayload.getNp().getTr())) {
                extCard = true;
            }
            ElementStructure payloadInReferencedType = referencedType.getDcref().getStructure();
            this.handleComplexPayload(mdslOperation, verb, binding, operation, boundParameter, payloadInReferencedType, mediaTypes, extCard);
            return;
        } else {
            if (operationPayload.getNp().getGenP() == null) throw new MDSLException("Unexpected (complex) element structure.");
            throw new MDSLException("Unexpected (complex) element structure: can't handle P and id-only here");
        }
    }

    private boolean treeHasMultiplicity(ParameterTree pt) {
        if (pt == null || pt.getCard() == null) {
            return false;
        }
        return pt.getCard().getZeroOrOne() != null || pt.getCard().getAtLeastOne() != null || pt.getCard().getZeroOrMore() != null;
    }

    private boolean referenceHasMultiplicity(TypeReference tr) {
        if (tr == null || tr.getCard() == null) {
            return false;
        }
        return tr.getCard().getZeroOrOne() != null || tr.getCard().getAtLeastOne() != null || tr.getCard().getZeroOrMore() != null;
    }

    private HTTPParameter defaultBindingFor(PathItem.HttpMethod verb) {
        if (this.verbIsAllowedToHaveRequestBody(verb)) {
            return HTTPParameter.BODY;
        }
        return HTTPParameter.QUERY;
    }

    private RequestBody createRequestBody(ElementStructure requestPayload, List<String> mediaTypes) {
        if (requestPayload != null) {
            if (mediaTypes != null) {
                RequestBody result = new RequestBody();
                Content c = new Content();
                MediaType item = new MediaType().schema(this.getSchema4RequestOrResponseStructure(requestPayload));
                for (int i = 0; i < mediaTypes.size(); ++i) {
                    c.addMediaType(mediaTypes.get(i), item);
                }
                result.setContent(c);
                return result;
            }
            this.mdslWrapper.logWarning("At least one media type must be defined.");
            return null;
        }
        return null;
    }

    private void handleResponseMessages(io.mdsl.apiDescription.Operation mdslOperation, HTTPResourceBinding binding, Operation operation) {
        if (this.mdslWrapper.operationHasReturnValue(mdslOperation)) {
            List<String> mediaTypes = this.mdslWrapper.findMediaTypeForResponse(mdslOperation, binding);
            ApiResponse apiResponse = this.createAPIResponse(mdslOperation.getResponseMessage().getPayload(), mdslOperation.getName() + " successful execution", mediaTypes);
            ApiResponses responseList = new ApiResponses().addApiResponse(DEFAULT_RESPONSE_NAME, apiResponse);
            this.handleLinks(mdslOperation, binding, apiResponse);
            if (this.mdslWrapper.operationHasReturnValueWithReports(mdslOperation)) {
                StatusReports reports = mdslOperation.getReports();
                EList<StatusReport> rl = reports.getReportList();
                for (int i = 0; i < rl.size(); ++i) {
                    ApiResponse reportResponse = null;
                    String code = "x-999";
                    String reportText = "tbd";
                    StatusReport report = (StatusReport)rl.get(i);
                    String reportNameInEndpointType = report.getName();
                    ElementStructure reportDataForResponse = report.getReportData();
                    if (reportDataForResponse == null) continue;
                    reportResponse = this.createAPIResponse(reportDataForResponse, mdslOperation.getName() + ": " + reportText, mediaTypes);
                    code = this.mdslWrapper.findReportCodeInBinding(mdslOperation.getName(), reportNameInEndpointType, binding);
                    reportText = this.mdslWrapper.findReportTextInBinding(mdslOperation.getName(), reportNameInEndpointType, binding);
                    reportResponse.description(reportText);
                    responseList.addApiResponse(code, reportResponse);
                }
            }
            operation.responses(responseList);
        } else {
            operation.responses(new ApiResponses().addApiResponse(DEFAULT_RESPONSE_NAME, new ApiResponse().description("no return value").content(new Content())));
        }
    }

    private void handleLinks(io.mdsl.apiDescription.Operation mdslOperation, HTTPResourceBinding binding, ApiResponse httpResponse) {
        EList<RelationshipLink> hypermediaRelations = mdslOperation.getRelations();
        for (int j = 0; j < hypermediaRelations.size(); ++j) {
            this.mdslWrapper.logInformation("Processing link relations in " + mdslOperation.getName());
            RelationshipLink nextLink = (RelationshipLink)hypermediaRelations.get(j);
            HTTPTypeBinding ltb = this.mdslWrapper.findLinkTypeBindingFor(nextLink.getLcref().getName(), binding);
            if (ltb == null) {
                this.mdslWrapper.logWarning("No binding found for " + nextLink.getName() + ", skipping this link.");
                continue;
            }
            this.handleSingleLink(nextLink, ltb, httpResponse);
        }
        io.mdsl.apiDescription.Operation compensatingOperation = mdslOperation.getUndo();
        if (compensatingOperation != null) {
            Link link = new Link().operationId(compensatingOperation.getName());
            httpResponse.link("compensatingOperation", link);
        }
    }

    private void handleSingleLink(RelationshipLink abstractLink, HTTPTypeBinding linkBinding, ApiResponse httpResponse) {
        String opId = "";
        if (linkBinding != null) {
            opId = ((HTTPResourceBinding)linkBinding.eContainer()).getName() + "-";
        }
        opId = abstractLink.getLcref().getOperation() != null ? opId + abstractLink.getLcref().getOperation() : "unknownOperation";
        Link link = new Link().operationId(opId);
        LinkContract refedLinkType = abstractLink.getLcref();
        if (refedLinkType != null && refedLinkType.getDataType() != null && refedLinkType.getDataType().getName() != null) {
            link.parameters(abstractLink.getName(), refedLinkType.getDataType().getName());
            if (refedLinkType.getOperation() != null) {
                link.description("Targeted operation: " + refedLinkType.getOperation());
            } else {
                link.description("Unknown target.");
            }
        }
        if (linkBinding.getHml().getLocal() != null) {
            link.parameters("resource", linkBinding.getHml().getLocal().getName());
        } else if (linkBinding.getHml().getExternal() != null) {
            link.parameters("resource", linkBinding.getHml().getExternal());
        }
        if (linkBinding.getHml().getVerb() != null) {
            link.parameters("verb", linkBinding.getHml().getVerb().getName());
        }
        if (linkBinding.getHml().getCmt() != null) {
            link.parameters("cmt", linkBinding.getHml().getCmt().getName());
        }
        Server server = new Server();
        String targetAddress = null;
        if (abstractLink.getLcref().getUrn() != null) {
            targetAddress = abstractLink.getLcref().getUrn();
        }
        if (linkBinding.getHml() != null && linkBinding.getHml().getExternal() != null) {
            targetAddress = linkBinding.getHml().getExternal();
        }
        if (targetAddress != null) {
            server.url(targetAddress);
            link.server(server);
        }
        httpResponse.link(abstractLink.getName(), link);
    }

    private List<SecurityRequirement> handleSecurity(EndpointContract endpointType, io.mdsl.apiDescription.Operation mdslOperation, HTTPResourceBinding binding) {
        ArrayList<SecurityRequirement> ss = new ArrayList<SecurityRequirement>();
        SecurityPolicies securityPolicies = mdslOperation.getPolicies();
        if (securityPolicies == null) {
            return null;
        }
        EList<SecurityPolicy> secPols = securityPolicies.getPolicyList();
        for (int i = 0; i < secPols.size(); ++i) {
            SecurityPolicy securityPolicy = (SecurityPolicy)secPols.get(i);
            String spName = securityPolicy.getName();
            SecurityBinding boundPolicy = this.mdslWrapper.findPolicyInBinding(mdslOperation.getName(), spName, binding);
            this.mdsl2OpenAPIConverter.convertPolicy2SecurityScheme(securityPolicy, boundPolicy);
            if (boundPolicy != null) {
                this.mdslWrapper.logInformation("Found a security policy " + spName + " for " + mdslOperation.getName());
                SecurityRequirement sr = new SecurityRequirement();
                sr.addList(spName);
                ss.add(sr);
                continue;
            }
            this.mdslWrapper.logWarning("Found a security policy (but no binding)" + spName + " for " + mdslOperation.getName() + ". Skipping it so that the generated OpenAPI validates.");
        }
        return ss;
    }

    private ApiResponse createAPIResponse(ElementStructure responsePayload, String description, List<String> mediaTypes) {
        Content c = new Content();
        mediaTypes.forEach(mediaType -> c.addMediaType(mediaType, new MediaType().schema(this.getSchema4RequestOrResponseStructure(responsePayload))));
        return new ApiResponse().description(description).content(c);
    }

    private Schema getSchema4RequestOrResponseStructure(ElementStructure payload) {
        if (payload.getNp() != null && payload.getNp().getTr() != null) {
            TypeReference tr = payload.getNp().getTr();
            return this.dataType2SchemaConverter.mapCardinalities(tr.getCard(), new Schema().$ref("#/components/schemas/" + tr.getDcref().getName()));
        }
        return this.dataType2SchemaConverter.convert(payload);
    }

    private PathItem.HttpMethod mapMethod(io.mdsl.apiDescription.Operation operation, HTTPResourceBinding binding) {
        PathItem.HttpMethod result = null;
        HTTPVerb verb = this.mdslWrapper.findVerbBindingFor(operation.getName(), binding);
        if (verb != null) {
            return this.mapMethodViaBinding(verb);
        }
        OperationResponsibility reponsibility = operation.getResponsibility();
        if (reponsibility != null && (result = this.mapMethodViaDecorator(reponsibility)) != null) {
            return result;
        }
        return this.mapMethodByName(operation);
    }

    private PathItem.HttpMethod mapMethodViaDecorator(OperationResponsibility reponsibility) {
        if (reponsibility == null) {
            return null;
        }
        if (reponsibility.getCf() != null) {
            return PathItem.HttpMethod.POST;
        }
        if (reponsibility.getSco() != null) {
            return PathItem.HttpMethod.PUT;
        }
        if (reponsibility.getRo() != null) {
            return PathItem.HttpMethod.GET;
        }
        if (reponsibility.getSto() != null) {
            return PathItem.HttpMethod.PATCH;
        }
        if (reponsibility.getSro() != null) {
            return PathItem.HttpMethod.PUT;
        }
        if (reponsibility.getSdo() != null) {
            return PathItem.HttpMethod.DELETE;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("POST")) {
            return PathItem.HttpMethod.POST;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("PUT")) {
            return PathItem.HttpMethod.PUT;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("PATCH")) {
            return PathItem.HttpMethod.PATCH;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("GET")) {
            return PathItem.HttpMethod.GET;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("DELETE")) {
            return PathItem.HttpMethod.DELETE;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("OPTIONS")) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("HEAD")) {
            return PathItem.HttpMethod.HEAD;
        }
        if (reponsibility.getOther() != null && reponsibility.getOther().equals("TRACE")) {
            return PathItem.HttpMethod.TRACE;
        }
        return null;
    }

    private PathItem.HttpMethod mapMethodViaBinding(HTTPVerb verb) {
        if (verb != null && verb == HTTPVerb.GET) {
            return PathItem.HttpMethod.GET;
        }
        if (verb != null && verb == HTTPVerb.PUT) {
            return PathItem.HttpMethod.PUT;
        }
        if (verb != null && verb == HTTPVerb.POST) {
            return PathItem.HttpMethod.POST;
        }
        if (verb != null && verb == HTTPVerb.PATCH) {
            return PathItem.HttpMethod.PATCH;
        }
        if (verb != null && verb == HTTPVerb.OPTIONS) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (verb != null && verb == HTTPVerb.HEAD) {
            return PathItem.HttpMethod.HEAD;
        }
        if (verb != null && verb == HTTPVerb.TRACE) {
            return PathItem.HttpMethod.TRACE;
        }
        if (verb != null && verb == HTTPVerb.DELETE) {
            return PathItem.HttpMethod.DELETE;
        }
        return null;
    }

    private PathItem.HttpMethod mapMethodByName(io.mdsl.apiDescription.Operation operation) {
        if (operation.getName().startsWith("create")) {
            return PathItem.HttpMethod.POST;
        }
        if (operation.getName().startsWith("addTo") || operation.getName().startsWith("add_to")) {
            return PathItem.HttpMethod.POST;
        }
        if (operation.getName().startsWith("get") || operation.getName().startsWith("read") || operation.getName().startsWith("retrieve") || operation.getName().startsWith("search")) {
            return PathItem.HttpMethod.GET;
        }
        if (operation.getName().startsWith("put") || operation.getName().startsWith("replace")) {
            return PathItem.HttpMethod.PUT;
        }
        if (operation.getName().startsWith("patch") || operation.getName().startsWith("update") || operation.getName().startsWith("modify")) {
            return PathItem.HttpMethod.PATCH;
        }
        if (operation.getName().startsWith("delete") || operation.getName().startsWith("remove")) {
            return PathItem.HttpMethod.DELETE;
        }
        this.mdslWrapper.logInformation("No heuristic found for " + operation.getName() + ", mapping to POST");
        return PathItem.HttpMethod.POST;
    }

    private boolean verbIsAllowedToHaveRequestBody(PathItem.HttpMethod verb) {
        return verb != PathItem.HttpMethod.GET && verb != PathItem.HttpMethod.DELETE;
    }
}

