/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.generator.AnonymousFieldNameGenerator;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.BooleanSchema;
import io.swagger.v3.oas.models.media.IntegerSchema;
import io.swagger.v3.oas.models.media.NumberSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.media.UUIDSchema;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;

public class DataType2SchemaConverter {
    public static final String REF_PREFIX = "#/components/schemas/";
    private AnonymousFieldNameGenerator fieldNameGenerator = new AnonymousFieldNameGenerator();

    public Schema convert(DataContract dataType) {
        return this.convert(dataType.getStructure()).name(dataType.getName());
    }

    public Schema convert(ElementStructure structure) {
        ObjectSchema object = new ObjectSchema();
        Map<String, Schema> propertySchemas = this.convertProperties(structure);
        if (propertySchemas != null && !propertySchemas.isEmpty()) {
            object.setProperties(propertySchemas);
        }
        if (structure.getApl() != null) {
            return this.mapCardinalities(structure.getApl().getCard(), (Schema)object);
        }
        if (structure.getPt() != null) {
            return this.mapCardinalities(structure.getPt().getCard(), (Schema)object);
        }
        return object;
    }

    public Schema convert(AtomicParameter atomicParameter) {
        RoleAndType rat = atomicParameter.getRat();
        Schema schema = this.getSchema4ParameterType(atomicParameter);
        schema.setName(this.fieldNameGenerator.getUniqueName(rat.getName()));
        if (atomicParameter.getCard() != null) {
            schema = this.mapCardinalities(atomicParameter.getCard(), schema);
        }
        return schema;
    }

    public Schema convertAndCreateSchema4TreeNode(ParameterTree pt, boolean externalCardinality) {
        ObjectSchema treeWrapperSchema = new ObjectSchema();
        treeWrapperSchema.setName(this.fieldNameGenerator.getUniqueName(pt.getName()));
        treeWrapperSchema.setProperties(this.convertProperties(pt));
        if (externalCardinality) {
            return this.getArrayWrapperSchema((Schema)treeWrapperSchema);
        }
        return this.mapCardinalities(pt.getCard(), (Schema)treeWrapperSchema);
    }

    public Schema mapCardinalities(Cardinality card, Schema schema) {
        if (card == null) {
            return schema;
        }
        if (card.getZeroOrMore() != null) {
            return this.getArrayWrapperSchema(schema);
        }
        if (card.getAtLeastOne() != null) {
            return this.getArrayWrapperSchema(schema).minItems(Integer.valueOf(1));
        }
        if (card.getExactlyOne() != null) {
            return schema.nullable(Boolean.valueOf(false));
        }
        if (card.getZeroOrOne() != null) {
            return schema.nullable(Boolean.valueOf(true));
        }
        return schema;
    }

    private Map<String, Schema> convertProperties(ElementStructure dataTypeStructure) {
        if (dataTypeStructure.getApl() != null) {
            return this.convertProperties(dataTypeStructure.getApl());
        }
        if (dataTypeStructure.getNp() != null) {
            return this.convertProperties(dataTypeStructure.getNp());
        }
        if (dataTypeStructure.getPf() != null) {
            return this.convertProperties(dataTypeStructure.getPf());
        }
        if (dataTypeStructure.getPt() != null) {
            return this.convertProperties(dataTypeStructure.getPt());
        }
        return null;
    }

    private Map<String, Schema> convertProperties(AtomicParameterList parameterList) {
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        Schema firstParameterSchema = this.convert(parameterList.getFirst());
        map.put(firstParameterSchema.getName(), firstParameterSchema);
        for (AtomicParameter nextParameter : parameterList.getNextap()) {
            Schema nextParameterSchema = this.convert(nextParameter);
            map.put(nextParameterSchema.getName(), nextParameterSchema);
        }
        return map;
    }

    private Map<String, Schema> convertProperties(SingleParameterNode parameterNode) {
        if (parameterNode.getGenP() != null) {
            return null;
        }
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        Schema schema = this.createSchema4SingleParameterNode(parameterNode);
        if (schema != null) {
            map.put(schema.getName(), schema);
        }
        return map;
    }

    private Map<String, Schema> convertProperties(ParameterForest parameterForest) {
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        if (parameterForest.getPtl() == null) {
            return map;
        }
        int treeCounter = 1;
        LinkedList trees = Lists.newLinkedList();
        trees.add(parameterForest.getPtl().getFirst());
        trees.addAll(parameterForest.getPtl().getNext());
        for (ParameterTree tree : trees) {
            Schema treeWrapperSchema = new ObjectSchema().name("tree" + treeCounter);
            treeWrapperSchema.setProperties(this.convertProperties(tree));
            map.put(treeWrapperSchema.getName(), treeWrapperSchema);
            ++treeCounter;
        }
        return map;
    }

    private Map<String, Schema> convertProperties(ParameterTree parameterTree) {
        LinkedHashMap<String, Schema> map = new LinkedHashMap<String, Schema>();
        Schema firstTreeNodeSchema = this.createSchema4TreeNode(parameterTree.getFirst());
        if (firstTreeNodeSchema != null) {
            map.put(firstTreeNodeSchema.getName(), firstTreeNodeSchema);
        }
        for (TreeNode nextNode : parameterTree.getNexttn()) {
            Schema nextSchema = this.createSchema4TreeNode(nextNode);
            if (nextSchema == null) continue;
            map.put(nextSchema.getName(), nextSchema);
        }
        return map;
    }

    private Schema createSchema4SingleParameterNode(SingleParameterNode singleNode) {
        if (singleNode.getAtomP() != null) {
            Schema atomPSchema = this.convert(singleNode.getAtomP());
            if (atomPSchema != null) {
                return atomPSchema;
            }
        } else {
            if (singleNode.getTr() != null) {
                String un = singleNode.getTr().getName();
                String refn = REF_PREFIX + singleNode.getTr().getDcref().getName();
                return this.mapCardinalities(singleNode.getTr().getCard(), new Schema().name(this.fieldNameGenerator.getUniqueName(un)).$ref(refn));
            }
            if (singleNode.getGenP() != null) {
                return new ObjectSchema().name(this.fieldNameGenerator.getUniqueName(singleNode.getGenP().getName()));
            }
        }
        return null;
    }

    private Schema createSchema4TreeNode(TreeNode node) {
        if (node.getApl() != null) {
            AtomicParameterList list = node.getApl();
            ObjectSchema listWrapperSchema = new ObjectSchema();
            listWrapperSchema.setName(this.fieldNameGenerator.getUniqueName(list.getName()));
            listWrapperSchema.setProperties(this.convertProperties(list));
            return this.mapCardinalities(node.getApl().getCard(), (Schema)listWrapperSchema);
        }
        if (node.getPn() != null) {
            return this.createSchema4SingleParameterNode(node.getPn());
        }
        if (node.getChildren() != null) {
            ParameterTree subTree = node.getChildren();
            ObjectSchema treeWrapperSchema = new ObjectSchema();
            treeWrapperSchema.setName(this.fieldNameGenerator.getUniqueName(subTree.getName()));
            treeWrapperSchema.setProperties(this.convertProperties(subTree));
            return this.mapCardinalities(subTree.getCard(), (Schema)treeWrapperSchema);
        }
        return null;
    }

    private Schema getArrayWrapperSchema(Schema schema) {
        return new ArraySchema().items(schema).name(schema.getName());
    }

    private Schema getSchema4ParameterType(AtomicParameter parameter) {
        if (parameter.getRat().getBtype() != null && !"".equals(parameter.getRat().getBtype())) {
            return this.getSchema4BasicType(parameter.getRat().getBtype());
        }
        if (parameter.getRat().getRole() != null && ("ID".equals(parameter.getRat().getRole()) || "Identifier".equals(parameter.getRat().getRole()))) {
            return new UUIDSchema();
        }
        if (parameter.getRat().getRole() != null && ("L".equals(parameter.getRat().getRole()) || "Link".equals(parameter.getRat().getRole()))) {
            return new URISchema();
        }
        return new StringSchema();
    }

    private Schema getSchema4BasicType(String basicType) {
        switch (basicType) {
            case "bool": {
                return new BooleanSchema();
            }
            case "int": {
                return new IntegerSchema();
            }
            case "long": {
                return new NumberSchema();
            }
            case "double": {
                return new NumberSchema();
            }
            case "string": {
                return new StringSchema();
            }
            case "raw": {
                return new BinarySchema();
            }
            case "void": {
                return new StringSchema();
            }
        }
        return new VoidSchema();
    }

    private class URISchema
    extends Schema<URI> {
        public URISchema() {
            super("string", "uri");
        }
    }

    private class VoidSchema
    extends Schema<Void> {
        public VoidSchema() {
            super("void", null);
        }
    }
}

