/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.openapi.converter.DataType2SchemaConverter;
import io.mdsl.utils.MAPLinkResolver;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DataType2ParameterConverter {
    private int anonymousParameterCounter = 1;
    private DataType2SchemaConverter schemaConverter = new DataType2SchemaConverter();
    private PatternStereotype classifier;
    private MDSLSpecificationWrapper mdslResolver;

    public DataType2ParameterConverter(ServiceSpecificationAdapter mdslSpecification) {
        this.mdslResolver = new MDSLSpecificationWrapper(mdslSpecification);
    }

    public Parameter convertTree(ParameterTree pt, PathItem.HttpMethod verb, HTTPParameter boundParameter, boolean externalCardinality) {
        Schema treeSchema = this.schemaConverter.convertAndCreateSchema4TreeNode(pt, externalCardinality);
        String treeName = pt.getName() != null ? pt.getName() : "anonymousTree";
        Parameter deepObjectForTree = new Parameter().name(treeName).in(this.convertParameterTypeToOpenAPIValue(boundParameter));
        deepObjectForTree.schema(treeSchema);
        if (boundParameter == HTTPParameter.QUERY) {
            deepObjectForTree.style(Parameter.StyleEnum.DEEPOBJECT);
        } else if (boundParameter == HTTPParameter.COOKIE) {
            deepObjectForTree.style(Parameter.StyleEnum.FORM);
        }
        deepObjectForTree.explode(Boolean.valueOf(true));
        return deepObjectForTree;
    }

    private List<Parameter> convertAPL(List<AtomicParameter> atomicParameters, PathItem.HttpMethod verb, HTTPParameter boundParameter) {
        return atomicParameters.stream().map(ap -> this.convertAP((AtomicParameter)ap, verb, boundParameter)).collect(Collectors.toList());
    }

    private Parameter convertAP(AtomicParameter atomicParameter, PathItem.HttpMethod verb, HTTPParameter paramType) {
        RoleAndType roleAndType = atomicParameter.getRat();
        this.classifier = atomicParameter.getClassifier();
        String descr = "unspecified";
        descr = this.getClassifier(roleAndType);
        boolean required = true;
        Cardinality card = atomicParameter.getCard();
        if (card != null && (card.getZeroOrOne() != null || card.getZeroOrMore() != null)) {
            required = false;
        }
        String inValue = this.convertParameterTypeToOpenAPIValue(paramType);
        Parameter result = null;
        if (card != null && (card.getZeroOrOne() != null || card.getAtLeastOne() != null)) {
            ArraySchema arraySchema = new ArraySchema();
            arraySchema.items(this.schemaConverter.convert(atomicParameter));
            result = new Parameter().name(this.getUniqueName(roleAndType.getName())).in(inValue).description(descr).required(Boolean.valueOf(required)).schema((Schema)arraySchema);
        } else {
            result = new Parameter().name(this.getUniqueName(roleAndType.getName())).in(inValue).description(descr).required(Boolean.valueOf(required)).schema(this.schemaConverter.convert(atomicParameter));
        }
        return result;
    }

    private String getClassifier(RoleAndType roleAndType) {
        String result = null;
        if (this.classifier != null) {
            String p = this.classifier.getPattern();
            if (p != null && !p.isEmpty()) {
                result = p;
            } else {
                p = this.classifier.getEip();
                if (p != null && !p.isEmpty()) {
                    result = p;
                } else {
                    p = this.classifier.getName();
                    if (p != null && !p.isEmpty()) {
                        result = p;
                    }
                }
            }
        }
        if (result != null && result.equals("unspecified")) {
            result = MAPLinkResolver.mapParameterRoleAndType(roleAndType);
        }
        return result;
    }

    public String convertParameterTypeToOpenAPIValue(HTTPParameter parameter) {
        if (parameter == null) {
            return null;
        }
        if (parameter == HTTPParameter.QUERY) {
            return "query";
        }
        if (parameter == HTTPParameter.HEADER) {
            return "header";
        }
        if (parameter == HTTPParameter.PATH) {
            return "path";
        }
        if (parameter == HTTPParameter.COOKIE) {
            return "cookie";
        }
        if (parameter == HTTPParameter.BODY) {
            throw new MDSLException("BODY is an unsupported mapping type");
        }
        throw new MDSLException("Unsupported mapping type");
    }

    private String getUniqueName(String originalName) {
        if (originalName != null && !"".equals(originalName)) {
            return originalName;
        }
        String anonymousName = "Parameter" + this.anonymousParameterCounter;
        ++this.anonymousParameterCounter;
        return anonymousName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Parameter> convertSingleRepresentationElementToOneOrMoreParameters(ElementStructure structure, PathItem.HttpMethod verb, HTTPParameter boundParameter) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
            return this.convertAPL(atomicParameterList, verb, boundParameter);
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
            return this.convertAPL(atomicParameterList, verb, boundParameter);
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                return this.convertSingleRepresentationElementToOneOrMoreParameters(structure.getNp().getTr().getDcref().getStructure(), verb, boundParameter);
            }
            if (structure.getPt() == null) throw new MDSLException("Parameter cannot be mapped, please simplify or extend it.");
            if (this.mdslResolver.isParameterTreeAtomic(structure.getPt())) {
                atomicParameterList.addAll(this.mdslResolver.collectAtomicParameters(structure.getPt()));
                return this.convertAPL(atomicParameterList, verb, boundParameter);
            } else {
                ArrayList<Parameter> pl = new ArrayList<Parameter>();
                pl.add(this.convertTree(structure.getPt(), verb, boundParameter, false));
                return pl;
            }
        }
    }

    public List<Parameter> convertSingleRepresentationElementToOneParameter(AtomicParameter ap, PathItem.HttpMethod verb, HTTPParameter boundParameter) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        result.add(this.convertAP(ap, verb, boundParameter));
        return result;
    }
}

