/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.ImplementationTechnology;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.Provider;
import io.mdsl.generator.model.ProviderImplementation;
import java.util.Optional;

public class ProviderImplementationConverter {
    private MDSLGeneratorModel genModel;

    public ProviderImplementationConverter(MDSLGeneratorModel genModel) {
        this.genModel = genModel;
    }

    public ProviderImplementation convert(io.mdsl.apiDescription.ProviderImplementation mdslProviderImplementation) {
        ProviderImplementation implementation = new ProviderImplementation(mdslProviderImplementation.getName(), this.findProvider(mdslProviderImplementation.getUpstreamBinding()), ImplementationTechnology.getTechnology(mdslProviderImplementation.getPlatform().getName()));
        implementation.setClass(mdslProviderImplementation.getClass_());
        implementation.setSuperClass(mdslProviderImplementation.getSuperclass());
        implementation.setDownstreamBinding(this.findProvider(mdslProviderImplementation.getDownstreamBinding()));
        return implementation;
    }

    private Provider findProvider(io.mdsl.apiDescription.Provider provider) {
        if (provider == null) {
            return null;
        }
        Optional<Provider> optProvider = this.genModel.getProviders().stream().filter(p -> p.getName().equals(provider.getName())).findFirst();
        if (optProvider.isEmpty()) {
            throw new MDSLException("MDSL error: The provider implementation '" + provider.getName() + "' references non-existing upstream binding (provider)!");
        }
        return optProvider.get();
    }
}

