/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import io.mdsl.apiDescription.EndpointList;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.EndpointContract;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.Provider;
import java.util.List;
import java.util.Optional;

public class ProviderConverter {
    private MDSLGeneratorModel genModel;

    public ProviderConverter(MDSLGeneratorModel genModel) {
        this.genModel = genModel;
    }

    public Provider convert(io.mdsl.apiDescription.Provider mdslProvider) {
        Provider provider = new Provider(mdslProvider.getName());
        this.mapEndpoints(provider, (List<EndpointList>)mdslProvider.getEpl());
        return provider;
    }

    private void mapEndpoints(Provider provider, List<EndpointList> endpoints) {
        for (EndpointList endpoint : endpoints) {
            Optional<EndpointContract> correspondingEndpoint = this.genModel.getEndpoints().stream().filter(e -> e.getName().equals(endpoint.getContract().getName())).findFirst();
            if (correspondingEndpoint.isEmpty()) {
                throw new MDSLException("MDSL error: a provider exposes an endpoint that does not exist!");
            }
            provider.addEndpoint(correspondingEndpoint.get());
        }
    }
}

