/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.model.Client;
import io.mdsl.generator.model.DataType;
import io.mdsl.generator.model.EndpointContract;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.Provider;
import io.mdsl.generator.model.ProviderImplementation;
import io.mdsl.generator.model.converter.ClientConverter;
import io.mdsl.generator.model.converter.DataTypeConverter;
import io.mdsl.generator.model.converter.EndpointConverter;
import io.mdsl.generator.model.converter.ProviderConverter;
import io.mdsl.generator.model.converter.ProviderImplementationConverter;
import java.util.LinkedList;
import java.util.List;

public class MDSL2GeneratorModelConverter {
    private ServiceSpecificationAdapter serviceSpecification;
    private DataTypeConverter dataTypeConverter;
    private EndpointConverter endpointConverter;
    private ProviderConverter providerConverter;
    private ClientConverter clientConverter;
    private ProviderImplementationConverter providerImplementationConverter;
    private MDSLGeneratorModel genModel;

    public MDSL2GeneratorModelConverter(ServiceSpecification serviceSpecification) {
        this.serviceSpecification = new ServiceSpecificationAdapter(serviceSpecification);
        this.genModel = new MDSLGeneratorModel(serviceSpecification.getName());
        this.dataTypeConverter = new DataTypeConverter(this.genModel);
        this.endpointConverter = new EndpointConverter(this.serviceSpecification, this.genModel, this.dataTypeConverter);
        this.providerConverter = new ProviderConverter(this.genModel);
        this.providerImplementationConverter = new ProviderImplementationConverter(this.genModel);
        this.clientConverter = new ClientConverter(this.genModel);
    }

    public MDSLGeneratorModel convert() {
        for (DataType dataType : this.convertDataTypes((List<DataContract>)this.serviceSpecification.getTypes())) {
            this.genModel.addDataType(dataType);
        }
        for (EndpointContract endpoint : this.convertEndpoints(this.serviceSpecification.getEndpointContracts())) {
            this.genModel.addEndpoint(endpoint);
        }
        for (Provider provider : this.convertProviders(this.serviceSpecification.getProviderProviders())) {
            this.genModel.addProvider(provider);
        }
        for (Client client : this.convertClients(this.serviceSpecification.getClientClients())) {
            this.genModel.addClient(client);
        }
        for (ProviderImplementation providerImpl : this.convertProviderImplementations((List<io.mdsl.apiDescription.ProviderImplementation>)this.serviceSpecification.getRealizations())) {
            this.genModel.addProviderImplementation(providerImpl);
        }
        return this.genModel;
    }

    private List<DataType> convertDataTypes(List<DataContract> contracts) {
        LinkedList dataTypes = Lists.newLinkedList();
        for (DataContract contract : contracts) {
            dataTypes.add(this.dataTypeConverter.convert(contract));
        }
        return dataTypes;
    }

    private List<EndpointContract> convertEndpoints(List<io.mdsl.apiDescription.EndpointContract> mdslEndpoints) {
        LinkedList endpoints = Lists.newLinkedList();
        for (io.mdsl.apiDescription.EndpointContract endpoint : mdslEndpoints) {
            endpoints.add(this.endpointConverter.convert(endpoint));
        }
        return endpoints;
    }

    private List<Provider> convertProviders(List<io.mdsl.apiDescription.Provider> mdslProviders) {
        LinkedList providers = Lists.newLinkedList();
        for (io.mdsl.apiDescription.Provider provider : mdslProviders) {
            providers.add(this.providerConverter.convert(provider));
        }
        return providers;
    }

    private List<Client> convertClients(List<io.mdsl.apiDescription.Client> mdslClients) {
        LinkedList clients = Lists.newLinkedList();
        for (io.mdsl.apiDescription.Client client : mdslClients) {
            clients.add(this.clientConverter.convert(client));
        }
        return clients;
    }

    private List<ProviderImplementation> convertProviderImplementations(List<io.mdsl.apiDescription.ProviderImplementation> mdslProviderImplemenations) {
        LinkedList providerImplementations = Lists.newLinkedList();
        for (io.mdsl.apiDescription.ProviderImplementation providerImpl : mdslProviderImplemenations) {
            providerImplementations.add(this.providerImplementationConverter.convert(providerImpl));
        }
        return providerImplementations;
    }
}

