/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import com.google.common.collect.Lists;
import io.mdsl.generator.model.Client;
import io.mdsl.generator.model.DataType;
import io.mdsl.generator.model.EndpointContract;
import io.mdsl.generator.model.Provider;
import io.mdsl.generator.model.ProviderImplementation;
import java.util.List;

public class MDSLGeneratorModel {
    private String apiName;
    private List<DataType> dataTypes;
    private List<EndpointContract> endpoints;
    private List<Provider> providers;
    private List<Client> clients;
    private List<ProviderImplementation> providerImplementations;

    public MDSLGeneratorModel(String apiName) {
        this.apiName = apiName;
        this.dataTypes = Lists.newLinkedList();
        this.endpoints = Lists.newLinkedList();
        this.providers = Lists.newLinkedList();
        this.clients = Lists.newLinkedList();
        this.providerImplementations = Lists.newLinkedList();
    }

    public String getApiName() {
        return this.apiName;
    }

    public List<DataType> getDataTypes() {
        return Lists.newLinkedList(this.dataTypes);
    }

    public List<EndpointContract> getEndpoints() {
        return Lists.newLinkedList(this.endpoints);
    }

    public List<Provider> getProviders() {
        return Lists.newLinkedList(this.providers);
    }

    public List<Client> getClients() {
        return Lists.newLinkedList(this.clients);
    }

    public List<ProviderImplementation> getProviderImplementations() {
        return Lists.newLinkedList(this.providerImplementations);
    }

    public void addDataType(DataType dataType) {
        this.dataTypes.add(dataType);
    }

    public void addEndpoint(EndpointContract endpoint) {
        this.endpoints.add(endpoint);
    }

    public void addProvider(Provider provider) {
        this.providers.add(provider);
    }

    public void addClient(Client client) {
        this.clients.add(client);
    }

    public void addProviderImplementation(ProviderImplementation providerImplementation) {
        this.providerImplementations.add(providerImplementation);
    }
}

