/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import io.mdsl.generator.model.MDSLType;

public enum BasicType implements MDSLType
{
    STRING("string"),
    BOOLEAN("bool"),
    INTEGER("int"),
    LONG("long"),
    DOUBLE("double"),
    RAW("raw"),
    VOID("void");

    private String name;
    private static final BasicType DEFAULT_BASIC_TYPE;

    private BasicType(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static BasicType byName(String basicTypeName) {
        if (basicTypeName == null) {
            return DEFAULT_BASIC_TYPE;
        }
        for (BasicType basicType : BasicType.values()) {
            if (!basicType.getName().equals(basicTypeName)) continue;
            return basicType;
        }
        return DEFAULT_BASIC_TYPE;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    static {
        DEFAULT_BASIC_TYPE = VOID;
    }
}

