/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.asyncapi.helpers;

import io.mdsl.apiDescription.AsyncEndpoint;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.CorrelationIdWhereClause;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.MessageBroker;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.WhereClauses;
import io.mdsl.generator.asyncapi.models.MessageBrokerDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class AsyncApiGeneratorHelper {
    public static List<MessageBrokerDto> getBrokers(ServiceSpecification sp) {
        LinkedList<MessageBrokerDto> map = new LinkedList<MessageBrokerDto>();
        sp.getProviders().stream().filter(item -> item instanceof MessageBroker).map(p -> (MessageBroker)p).forEach(msgprovider -> {
            int brokerLocationsCount = 0;
            for (AsyncEndpoint l : msgprovider.getEpl()) {
                MessageBrokerDto b = new MessageBrokerDto(++brokerLocationsCount > 1 ? msgprovider.getName() + brokerLocationsCount : msgprovider.getName(), l.getLocation(), AsyncApiGeneratorHelper.getProtocolAsString(l.getPb().getProtBinding()), msgprovider.getDescription() != null ? msgprovider.getDescription() : "No description specified", l.getBindings());
                map.add(b);
            }
        });
        return map;
    }

    public static String getProtocolAsString(ProtocolBinding pb) {
        if (pb.getGrpc() != null) {
            return pb.getGrpc().getBinding();
        }
        if (pb.getHttp() != null) {
            return pb.getHttp().getHttp();
        }
        if (pb.getJava() != null) {
            return pb.getJava().getBinding();
        }
        if (pb.getOther() != null) {
            if (pb.getOther().getAmqp() != null) {
                return pb.getOther().getAmqp();
            }
            if (pb.getOther().getAvro() != null) {
                return pb.getOther().getAvro();
            }
            if (pb.getOther().getJms() != null) {
                return pb.getOther().getJms();
            }
            if (pb.getOther().getKafka() != null) {
                return pb.getOther().getKafka();
            }
            if (pb.getOther().getMqtt() != null) {
                return pb.getOther().getMqtt();
            }
            if (pb.getOther().getOther() != null) {
                return pb.getOther().getOther();
            }
            if (pb.getOther().getSoap() != null) {
                return pb.getOther().getSoap();
            }
            if (pb.getOther().getStomp() != null) {
                return pb.getOther().getStomp();
            }
            if (pb.getOther().getThrift() != null) {
                return pb.getOther().getThrift();
            }
        }
        return "Unknown protocol";
    }

    public static String getProtocolBindingPropertyName(ProtocolBinding transportProtocol) {
        return AsyncApiGeneratorHelper.getProtocolBindingPropertyName(AsyncApiGeneratorHelper.getProtocolAsString(transportProtocol));
    }

    public static String getProtocolBindingPropertyName(String protocol) {
        switch (protocol) {
            case "JMS_ActiveMQ": {
                return "jms";
            }
        }
        return protocol.toLowerCase();
    }

    public static CorrelationIdWhereClause getCorrelationId(List<WhereClauses> whereClauses) {
        if (whereClauses != null) {
            for (WhereClauses wc : whereClauses) {
                if (!(wc instanceof CorrelationIdWhereClause)) continue;
                return (CorrelationIdWhereClause)wc;
            }
        }
        return null;
    }

    public static boolean isArray(Cardinality card) {
        if (card == null) {
            return false;
        }
        return card.getAtLeastOne() != null || card.getZeroOrMore() != null;
    }

    public static List<ParameterTree> getRootTrees(ParameterForest pf) {
        ArrayList<ParameterTree> trees = new ArrayList<ParameterTree>();
        trees.add(pf.getPtl().getFirst());
        trees.addAll((Collection<ParameterTree>)pf.getPtl().getNext());
        return trees;
    }

    public static boolean isRootTypeReference(ElementStructure elemStr) {
        return elemStr != null && elemStr.getNp() != null && elemStr.getNp().getTr() != null;
    }
}

