/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.asyncapi;

import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ParameterTreeList;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.generator.asyncapi.helpers.AsyncApiGeneratorHelper;
import io.mdsl.generator.asyncapi.models.CardinalityDescription;
import io.mdsl.generator.asyncapi.models.ParameterDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class AsyncApiDataTypeGenerator {
    private int genericParameterNameCount = 1;

    public CharSequence compile(ElementStructure dto) {
        StringConcatenation _builder = new StringConcatenation();
        SingleParameterNode _np = dto.getNp();
        CharSequence _compile = null;
        if (_np != null) {
            _compile = this.compile(_np);
        }
        _builder.append(_compile);
        _builder.newLineIfNotEmpty();
        ParameterTree _pt = dto.getPt();
        CharSequence _compile_1 = null;
        if (_pt != null) {
            _compile_1 = this.compile(_pt);
        }
        _builder.append(_compile_1);
        _builder.newLineIfNotEmpty();
        ParameterForest _pf = dto.getPf();
        CharSequence _compile_2 = null;
        if (_pf != null) {
            _compile_2 = this.compile(_pf);
        }
        _builder.append(_compile_2);
        _builder.newLineIfNotEmpty();
        AtomicParameterList _apl = dto.getApl();
        CharSequence _compile_3 = null;
        if (_apl != null) {
            _compile_3 = this.compile(_apl);
        }
        _builder.append(_compile_3);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence compile(ParameterForest pf) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("type: array");
        _builder.newLine();
        _builder.append("items:");
        _builder.newLine();
        List<ParameterTree> _rootTrees = AsyncApiGeneratorHelper.getRootTrees(pf);
        for (ParameterTree tree : _rootTrees) {
            _builder.append("\t");
            _builder.append("-");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _compile = this.compile(tree);
            _builder.append((Object)_compile, "\t\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence compile(ParameterTree pt) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = AsyncApiGeneratorHelper.isArray(pt.getCard());
        if (_isArray) {
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("items:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _insertRequiredProperties = this.insertRequiredProperties(this.getRequiredProperties(pt));
            _builder.append((Object)_insertRequiredProperties, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("\t\t");
            CharSequence _compileTreeNoHead = this.compileTreeNoHead(pt);
            _builder.append((Object)_compileTreeNoHead, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("type: object");
            _builder.newLine();
            CharSequence _insertRequiredProperties_1 = this.insertRequiredProperties(this.getRequiredProperties(pt));
            _builder.append((Object)_insertRequiredProperties_1);
            _builder.newLineIfNotEmpty();
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _compileTreeNoHead_1 = this.compileTreeNoHead(pt);
            _builder.append((Object)_compileTreeNoHead_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence compileTreeNoHead(ParameterTree pt) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        TreeNode _first = pt.getFirst();
        CharSequence _compile = null;
        if (_first != null) {
            _compile = this.compile(_first);
        }
        _builder.append(_compile);
        _builder.newLineIfNotEmpty();
        EList<TreeNode> _nexttn = pt.getNexttn();
        boolean bl = _tripleNotEquals = _nexttn != null;
        if (_tripleNotEquals) {
            EList<TreeNode> _nexttn_1 = pt.getNexttn();
            for (TreeNode treeNode : _nexttn_1) {
                CharSequence _compile_1 = this.compile(treeNode);
                _builder.append((Object)_compile_1);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence compile(TreeNode tn) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        AtomicParameterList _apl = tn.getApl();
        CharSequence _compile = null;
        if (_apl != null) {
            _compile = this.compile(_apl);
        }
        _builder.append(_compile);
        _builder.newLineIfNotEmpty();
        SingleParameterNode _pn = tn.getPn();
        CharSequence _compileSingleParameterNodeOnlyProp = null;
        if (_pn != null) {
            _compileSingleParameterNodeOnlyProp = this.compileSingleParameterNodeOnlyProp(_pn);
        }
        _builder.append(_compileSingleParameterNodeOnlyProp);
        _builder.newLineIfNotEmpty();
        ParameterTree _children = tn.getChildren();
        boolean bl = _tripleNotEquals = _children != null;
        if (_tripleNotEquals) {
            String _nameOrPlaceholder = this.getNameOrPlaceholder(tn.getChildren().getName());
            _builder.append(_nameOrPlaceholder);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            boolean _isArray = AsyncApiGeneratorHelper.isArray(tn.getChildren().getCard());
            if (_isArray) {
                _builder.append("\t");
                CharSequence _compile_1 = this.compile(tn.getChildren());
                _builder.append((Object)_compile_1, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("type: object");
                _builder.newLine();
                _builder.append("\t");
                CharSequence _insertRequiredProperties = this.insertRequiredProperties(this.getRequiredProperties(tn.getChildren()));
                _builder.append((Object)_insertRequiredProperties, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("properties:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _compileTreeNoHead = this.compileTreeNoHead(tn.getChildren());
                _builder.append((Object)_compileTreeNoHead, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence compile(AtomicParameterList apl) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = AsyncApiGeneratorHelper.isArray(apl.getCard());
        if (_isArray) {
            boolean _tripleNotEquals;
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("items:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("type: object");
            _builder.newLine();
            _builder.append("\t");
            CharSequence _insertRequiredProperties = this.insertRequiredProperties(this.getRequiredProperties(apl));
            _builder.append((Object)_insertRequiredProperties, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("\t\t");
            AtomicParameter _first = apl.getFirst();
            CharSequence _compile = null;
            if (_first != null) {
                _compile = this.compile(_first);
            }
            _builder.append((Object)_compile, "\t\t");
            _builder.newLineIfNotEmpty();
            EList<AtomicParameter> _nextap = apl.getNextap();
            boolean bl = _tripleNotEquals = _nextap != null;
            if (_tripleNotEquals) {
                EList<AtomicParameter> _nextap_1 = apl.getNextap();
                for (AtomicParameter atomP : _nextap_1) {
                    _builder.append("\t\t");
                    CharSequence _compile_1 = this.compile(atomP);
                    _builder.append((Object)_compile_1, "\t\t");
                    _builder.newLineIfNotEmpty();
                }
            }
        } else {
            boolean _tripleNotEquals_1;
            _builder.newLine();
            _builder.append("type: object");
            _builder.newLine();
            CharSequence _insertRequiredProperties_1 = this.insertRequiredProperties(this.getRequiredProperties(apl));
            _builder.append((Object)_insertRequiredProperties_1);
            _builder.newLineIfNotEmpty();
            _builder.append("properties:");
            _builder.newLine();
            _builder.append("\t");
            AtomicParameter _first_1 = apl.getFirst();
            CharSequence _compile_2 = null;
            if (_first_1 != null) {
                _compile_2 = this.compile(_first_1);
            }
            _builder.append((Object)_compile_2, "\t");
            _builder.newLineIfNotEmpty();
            EList<AtomicParameter> _nextap_2 = apl.getNextap();
            boolean bl = _tripleNotEquals_1 = _nextap_2 != null;
            if (_tripleNotEquals_1) {
                EList<AtomicParameter> _nextap_3 = apl.getNextap();
                for (AtomicParameter atomP_1 : _nextap_3) {
                    _builder.append("\t");
                    CharSequence _compile_3 = this.compile(atomP_1);
                    _builder.append((Object)_compile_3, "\t");
                    _builder.newLineIfNotEmpty();
                }
            }
        }
        _builder.newLine();
        return _builder;
    }

    private LinkedList<String> getRequiredProperties(AtomicParameterList apl) {
        ArrayList<AtomicParameter> parameters = new ArrayList<AtomicParameter>();
        parameters.add(apl.getFirst());
        parameters.addAll((Collection<AtomicParameter>)apl.getNextap());
        LinkedList<String> requiredParams = new LinkedList<String>();
        for (AtomicParameter p : parameters) {
            boolean _not;
            boolean _tripleNotEquals;
            boolean _or = false;
            Cardinality _card = p.getCard();
            String _zeroOrMore = null;
            if (_card != null) {
                _zeroOrMore = _card.getZeroOrMore();
            }
            boolean bl = _tripleNotEquals = _zeroOrMore != null;
            if (_tripleNotEquals) {
                _or = true;
            } else {
                boolean _tripleNotEquals_1;
                Cardinality _card_1 = p.getCard();
                String _zeroOrOne = null;
                if (_card_1 != null) {
                    _zeroOrOne = _card_1.getZeroOrOne();
                }
                _or = _tripleNotEquals_1 = _zeroOrOne != null;
            }
            if (!(_not = !_or)) continue;
            requiredParams.add(p.getRat().getName());
        }
        return requiredParams;
    }

    private ArrayList<String> getRequiredProperties(List<TreeNode> properties) {
        Functions.Function1 _function = p -> {
            ParameterTree _children;
            boolean _tripleNotEquals_5;
            boolean _tripleNotEquals_1;
            boolean _tripleNotEquals;
            AtomicParameterList _apl = p.getApl();
            boolean bl = _tripleNotEquals = _apl != null;
            if (_tripleNotEquals) {
                String _name = p.getApl().getName();
                Cardinality _card = p.getApl().getCard();
                return new ParameterDescriptor(_name, _card);
            }
            SingleParameterNode _pn = p.getPn();
            boolean bl2 = _tripleNotEquals_1 = _pn != null;
            if (_tripleNotEquals_1) {
                boolean _tripleNotEquals_4;
                boolean _tripleNotEquals_3;
                boolean _tripleNotEquals_2;
                AtomicParameter _atomP = p.getPn().getAtomP();
                boolean bl3 = _tripleNotEquals_2 = _atomP != null;
                if (_tripleNotEquals_2) {
                    String _name_1 = p.getPn().getAtomP().getRat().getName();
                    Cardinality _card_1 = p.getPn().getAtomP().getCard();
                    return new ParameterDescriptor(_name_1, _card_1);
                }
                GenericParameter _genP = p.getPn().getGenP();
                boolean bl4 = _tripleNotEquals_3 = _genP != null;
                if (_tripleNotEquals_3) {
                    String _name_2 = p.getPn().getGenP().getName();
                    return new ParameterDescriptor(_name_2, null);
                }
                TypeReference _tr = p.getPn().getTr();
                boolean bl5 = _tripleNotEquals_4 = _tr != null;
                if (_tripleNotEquals_4) {
                    String _name_3 = p.getPn().getTr().getName();
                    Cardinality _card_2 = p.getPn().getTr().getCard();
                    return new ParameterDescriptor(_name_3, _card_2);
                }
            }
            boolean bl6 = _tripleNotEquals_5 = (_children = p.getChildren()) != null;
            if (_tripleNotEquals_5) {
                String _name_4 = p.getChildren().getName();
                Cardinality _card_3 = p.getChildren().getCard();
                return new ParameterDescriptor(_name_4, _card_3);
            }
            return null;
        };
        List allProperties = ListExtensions.map(properties, (Functions.Function1)_function);
        ArrayList<String> requiredProperties = new ArrayList<String>();
        for (ParameterDescriptor p2 : allProperties) {
            boolean _tripleNotEquals;
            boolean _or = false;
            Cardinality _card = p2.getCard();
            String _zeroOrMore = null;
            if (_card != null) {
                _zeroOrMore = _card.getZeroOrMore();
            }
            boolean bl = _tripleNotEquals = _zeroOrMore != null;
            if (_tripleNotEquals) {
                _or = true;
            } else {
                boolean _tripleNotEquals_1;
                Cardinality _card_1 = p2.getCard();
                String _zeroOrOne = null;
                if (_card_1 != null) {
                    _zeroOrOne = _card_1.getZeroOrOne();
                }
                _or = _tripleNotEquals_1 = _zeroOrOne != null;
            }
            if (_or) continue;
            requiredProperties.add(p2.getName());
        }
        return requiredProperties;
    }

    private ArrayList<String> getRequiredProperties(ParameterTree pt) {
        ArrayList<TreeNode> properties = new ArrayList<TreeNode>();
        properties.add(pt.getFirst());
        properties.addAll((Collection<TreeNode>)pt.getNexttn());
        return this.getRequiredProperties(properties);
    }

    private CharSequence insertRequiredProperties(List<String> params) {
        StringConcatenation _builder = new StringConcatenation();
        if (params != null && ((Object[])Conversions.unwrapArray(params, Object.class)).length > 0 && IterableExtensions.join((Iterable)ListExtensions.map(params, p -> {
            String _xifexpression = null;
            _xifexpression = p != null ? p : "";
            return _xifexpression;
        })).length() > 0) {
            _builder.append("required:");
            _builder.newLine();
            for (String p2 : params) {
                if (p2 == null || p2.length() <= 0) continue;
                _builder.append("\t");
                _builder.append("-  ");
                String _nameOrPlaceholder = this.getNameOrPlaceholder(p2);
                _builder.append(_nameOrPlaceholder, "\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence compile(TypeReference tr) {
        return this.compile(tr, true);
    }

    public CharSequence compile(TypeReference tr, boolean hasName) {
        boolean _isArray;
        StringConcatenation _builder = new StringConcatenation();
        if (hasName) {
            String _nameOrPlaceholder = this.getNameOrPlaceholder(tr.getName());
            _builder.append(_nameOrPlaceholder);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
        }
        Cardinality _card = null;
        if (tr != null) {
            _card = tr.getCard();
        }
        if (_isArray = AsyncApiGeneratorHelper.isArray(_card)) {
            _builder.append("\t");
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("items:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("$ref: '#/components/schemas/");
            String _name = tr.getDcref().getName();
            _builder.append(_name, "\t\t");
            _builder.append("'");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("$ref: '#/components/schemas/");
            String _name_1 = tr.getDcref().getName();
            _builder.append(_name_1, "\t");
            _builder.append("'");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String getNameOrPlaceholder(String name) {
        if (name != null && name.length() > 0) {
            return "'" + name + "'";
        }
        int _plusPlus = this.genericParameterNameCount++;
        return "unnamedParameter" + Integer.valueOf(_plusPlus);
    }

    private CharSequence compile(AtomicParameter atomP) {
        boolean _isArray;
        StringConcatenation _builder = new StringConcatenation();
        String _nameOrPlaceholder = this.getNameOrPlaceholder(atomP.getRat().getName());
        _builder.append(_nameOrPlaceholder);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        Cardinality _card = null;
        if (atomP != null) {
            _card = atomP.getCard();
        }
        if (_isArray = AsyncApiGeneratorHelper.isArray(_card)) {
            _builder.append("\t");
            _builder.append("type: array");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("items: ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("type: ");
            String _type = this.getType(atomP);
            _builder.append(_type, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            _builder.append("\t");
            _builder.append("type: ");
            String _type_1 = this.getType(atomP);
            _builder.append(_type_1, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence compile(SingleParameterNode spn) {
        boolean _tripleEquals;
        StringConcatenation _builder = new StringConcatenation();
        TypeReference _tr = spn.getTr();
        boolean bl = _tripleEquals = _tr == null;
        if (_tripleEquals) {
            boolean _tripleNotEquals;
            _builder.append("type: object");
            _builder.newLine();
            GenericParameter _genP = spn.getGenP();
            boolean bl2 = _tripleNotEquals = _genP != null;
            if (_tripleNotEquals) {
                GenericParameter _genP_1 = spn.getGenP();
                CharSequence _compile = null;
                if (_genP_1 != null) {
                    _compile = this.compile(_genP_1);
                }
                _builder.append(_compile);
                _builder.newLineIfNotEmpty();
            } else {
                boolean _tripleEquals_1;
                boolean _and = false;
                AtomicParameter _atomP = null;
                if (spn != null) {
                    _atomP = spn.getAtomP();
                }
                Cardinality _card = null;
                if (_atomP != null) {
                    _card = _atomP.getCard();
                }
                String _zeroOrOne = null;
                if (_card != null) {
                    _zeroOrOne = _card.getZeroOrOne();
                }
                boolean bl3 = _tripleEquals_1 = _zeroOrOne == null;
                if (!_tripleEquals_1) {
                    _and = false;
                } else {
                    boolean _tripleNotEquals_1;
                    AtomicParameter _atomP_1 = null;
                    if (spn != null) {
                        _atomP_1 = spn.getAtomP();
                    }
                    RoleAndType _rat = null;
                    if (_atomP_1 != null) {
                        _rat = _atomP_1.getRat();
                    }
                    String _name = null;
                    if (_rat != null) {
                        _name = _rat.getName();
                    }
                    _and = _tripleNotEquals_1 = _name != null;
                }
                if (_and) {
                    _builder.append("required:");
                    _builder.newLine();
                    _builder.append("\t");
                    _builder.append("-  ");
                    String _nameOrPlaceholder = this.getNameOrPlaceholder(spn.getAtomP().getRat().getName());
                    _builder.append(_nameOrPlaceholder, "\t");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("properties:");
                _builder.newLine();
                _builder.append("\t");
                AtomicParameter _atomP_2 = spn.getAtomP();
                CharSequence _compile_1 = null;
                if (_atomP_2 != null) {
                    _compile_1 = this.compile(_atomP_2);
                }
                _builder.append((Object)_compile_1, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            CharSequence _compile_2 = this.compile(spn.getTr());
            _builder.append((Object)_compile_2);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence compileSingleParameterNodeOnlyProp(SingleParameterNode spn) {
        StringConcatenation _builder = new StringConcatenation();
        GenericParameter _genP = spn.getGenP();
        CharSequence _compile = null;
        if (_genP != null) {
            _compile = this.compile(_genP);
        }
        _builder.append(_compile);
        _builder.newLineIfNotEmpty();
        AtomicParameter _atomP = spn.getAtomP();
        CharSequence _compile_1 = null;
        if (_atomP != null) {
            _compile_1 = this.compile(_atomP);
        }
        _builder.append(_compile_1);
        _builder.newLineIfNotEmpty();
        TypeReference _tr = spn.getTr();
        CharSequence _compile_2 = null;
        if (_tr != null) {
            _compile_2 = this.compile(_tr);
        }
        _builder.append(_compile_2);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence compile(GenericParameter genP) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = null;
        if (genP != null) {
            _name = genP.getName();
        }
        String _nameOrPlaceholder = this.getNameOrPlaceholder(_name);
        _builder.append(_nameOrPlaceholder);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("type: object");
        _builder.newLine();
        return _builder;
    }

    private String getType(AtomicParameter atomP) {
        String type = this.getType(atomP.getRat().getBtype());
        if (type != null && type.length() > 0) {
            return type;
        }
        return this.getTypeFromRole(atomP.getRat().getRole());
    }

    public String getType(String type) {
        if (type != null) {
            switch (type) {
                case "int": {
                    return "integer";
                }
                case "double": {
                    return "number";
                }
                case "long": {
                    return "number";
                }
                case "bool": {
                    return "boolean";
                }
                case "raw": {
                    return "string";
                }
                case "void": {
                    return "['null']";
                }
            }
            return type;
        }
        return type;
    }

    private String getTypeFromRole(String role) {
        return "object";
    }

    public CardinalityDescription getRootPayloadCardinality(ElementStructure root) {
        boolean _isArray_3;
        boolean _isArray_2;
        boolean _isArray_1;
        boolean _isArray;
        CardinalityDescription cardDescription = new CardinalityDescription(false, false);
        AtomicParameterList _apl = null;
        if (root != null) {
            _apl = root.getApl();
        }
        Cardinality _card = null;
        if (_apl != null) {
            _card = _apl.getCard();
        }
        if (_isArray = AsyncApiGeneratorHelper.isArray(_card)) {
            cardDescription.setArray(true);
            String _atLeastOne = root.getApl().getCard().getAtLeastOne();
            boolean _tripleNotEquals = _atLeastOne != null;
            cardDescription.setAtLeastOne(_tripleNotEquals);
        }
        SingleParameterNode _np = null;
        if (root != null) {
            _np = root.getNp();
        }
        AtomicParameter _atomP = null;
        if (_np != null) {
            _atomP = _np.getAtomP();
        }
        Cardinality _card_1 = null;
        if (_atomP != null) {
            _card_1 = _atomP.getCard();
        }
        if (_isArray_1 = AsyncApiGeneratorHelper.isArray(_card_1)) {
            cardDescription.setArray(true);
            String _atLeastOne_1 = root.getNp().getAtomP().getCard().getAtLeastOne();
            boolean _tripleNotEquals_1 = _atLeastOne_1 != null;
            cardDescription.setAtLeastOne(_tripleNotEquals_1);
        }
        SingleParameterNode _np_1 = null;
        if (root != null) {
            _np_1 = root.getNp();
        }
        TypeReference _tr = null;
        if (_np_1 != null) {
            _tr = _np_1.getTr();
        }
        Cardinality _card_2 = null;
        if (_tr != null) {
            _card_2 = _tr.getCard();
        }
        if (_isArray_2 = AsyncApiGeneratorHelper.isArray(_card_2)) {
            cardDescription.setArray(true);
            String _atLeastOne_2 = root.getNp().getTr().getCard().getAtLeastOne();
            boolean _tripleNotEquals_2 = _atLeastOne_2 != null;
            cardDescription.setAtLeastOne(_tripleNotEquals_2);
        }
        ParameterForest _pf = null;
        if (root != null) {
            _pf = root.getPf();
        }
        ParameterTreeList _ptl = null;
        if (_pf != null) {
            _ptl = _pf.getPtl();
        }
        ParameterTree _first = null;
        if (_ptl != null) {
            _first = _ptl.getFirst();
        }
        Cardinality _card_3 = null;
        if (_first != null) {
            _card_3 = _first.getCard();
        }
        if (_isArray_3 = AsyncApiGeneratorHelper.isArray(_card_3)) {
            cardDescription.setArray(true);
            String _atLeastOne_3 = root.getPf().getPtl().getFirst().getCard().getAtLeastOne();
            boolean _tripleNotEquals_3 = _atLeastOne_3 != null;
            cardDescription.setAtLeastOne(_tripleNotEquals_3);
        }
        return cardDescription;
    }
}

