/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.freemarker.FreemarkerEngineWrapper;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class TextFileGenerator
extends AbstractMDSLGenerator {
    private File freemarkerTemplateFile;
    private String targetFileName;
    private Map<String, Object> customDataMap = new HashMap<String, Object>();

    public void setFreemarkerTemplateFile(File freemarkerTemplateFile) {
        this.freemarkerTemplateFile = freemarkerTemplateFile;
    }

    public void setTargetFileName(String targetFileName) {
        this.targetFileName = targetFileName;
    }

    public void registerCustomModelProperty(String propertyName, Object object) {
        this.customDataMap.put(propertyName, object);
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        if (this.freemarkerTemplateFile == null) {
            throw new MDSLException("The freemarker template has not been set!");
        }
        if (!this.freemarkerTemplateFile.exists()) {
            throw new MDSLException("The file '" + this.freemarkerTemplateFile.getAbsolutePath().toString() + "' does not exist!");
        }
        if (this.targetFileName == null || "".equals(this.targetFileName)) {
            throw new MDSLException("Please provide a name for the file that shall be generated.");
        }
        this.registerCustomModelProperty("timeStamp", new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()));
        this.registerCustomModelProperty("fileName", mdslSpecification.eResource().getURI().lastSegment().toString());
        this.registerCustomModelProperty("apiName", mdslSpecification.getName());
        FreemarkerEngineWrapper freemarkerWrapper = new FreemarkerEngineWrapper(this.freemarkerTemplateFile);
        for (Map.Entry<String, Object> customDataEntry : this.customDataMap.entrySet()) {
            freemarkerWrapper.registerCustomData(customDataEntry.getKey(), customDataEntry.getValue());
        }
        fsa.generateFile(this.targetFileName, (CharSequence)freemarkerWrapper.generate(mdslSpecification));
    }
}

