/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import com.google.common.collect.Sets;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.openapi.converter.MDSL2OpenAPIConverter;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class OpenAPIGenerator
extends AbstractMDSLGenerator {
    private Set<String> validationMessages;

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        String fileName = inputFileURI.trimFileExtension().lastSegment() + ".yaml";
        this.validationMessages = Sets.newHashSet();
        OpenAPI oas = new MDSL2OpenAPIConverter(mdslSpecification).convert();
        String yaml = Yaml.pretty((Object)oas);
        SwaggerParseResult parseResult = new OpenAPIV3Parser().readContents(yaml);
        this.validationMessages.addAll(parseResult.getMessages());
        fsa.generateFile(fileName, (CharSequence)yaml);
    }

    public Set<String> getValidationMessages() {
        return this.validationMessages;
    }
}

