/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StreamingOption implements Enumerator
{
    CLIENT(0, "client", "client"),
    SERVER(1, "server", "server"),
    BIDIRECTIONAL(2, "bidirectional", "bidirectional");

    public static final int CLIENT_VALUE = 0;
    public static final int SERVER_VALUE = 1;
    public static final int BIDIRECTIONAL_VALUE = 2;
    private static final StreamingOption[] VALUES_ARRAY;
    public static final List<StreamingOption> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static StreamingOption get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            StreamingOption result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static StreamingOption getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            StreamingOption result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static StreamingOption get(int value) {
        switch (value) {
            case 0: {
                return CLIENT;
            }
            case 1: {
                return SERVER;
            }
            case 2: {
                return BIDIRECTIONAL;
            }
        }
        return null;
    }

    private StreamingOption(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new StreamingOption[]{CLIENT, SERVER, BIDIRECTIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

