/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum SLAType implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    IMPLICIT(1, "IMPLICIT", "IMPLICIT"),
    INFORMAL(2, "INFORMAL", "INFORMAL"),
    QUALITATIVE(3, "QUALITATIVE", "QUALITATIVE"),
    QUANTITATIVE(4, "QUANTITATIVE", "QUANTITATIVE");

    public static final int NONE_VALUE = 0;
    public static final int IMPLICIT_VALUE = 1;
    public static final int INFORMAL_VALUE = 2;
    public static final int QUALITATIVE_VALUE = 3;
    public static final int QUANTITATIVE_VALUE = 4;
    private static final SLAType[] VALUES_ARRAY;
    public static final List<SLAType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static SLAType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SLAType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static SLAType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            SLAType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static SLAType get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return IMPLICIT;
            }
            case 2: {
                return INFORMAL;
            }
            case 3: {
                return QUALITATIVE;
            }
            case 4: {
                return QUANTITATIVE;
            }
        }
        return null;
    }

    private SLAType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new SLAType[]{NONE, IMPLICIT, INFORMAL, QUALITATIVE, QUANTITATIVE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

