/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageType implements Enumerator
{
    COMMAND_MESSAGE(0, "COMMAND_MESSAGE", "COMMAND_MESSAGE"),
    EVENT_MESSAGE(1, "EVENT_MESSAGE", "EVENT_MESSAGE"),
    DOCUMENT_MESSAGE(2, "DOCUMENT_MESSAGE", "DOCUMENT_MESSAGE");

    public static final int COMMAND_MESSAGE_VALUE = 0;
    public static final int EVENT_MESSAGE_VALUE = 1;
    public static final int DOCUMENT_MESSAGE_VALUE = 2;
    private static final MessageType[] VALUES_ARRAY;
    public static final List<MessageType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MessageType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MessageType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MessageType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MessageType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MessageType get(int value) {
        switch (value) {
            case 0: {
                return COMMAND_MESSAGE;
            }
            case 1: {
                return EVENT_MESSAGE;
            }
            case 2: {
                return DOCUMENT_MESSAGE;
            }
        }
        return null;
    }

    private MessageType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MessageType[]{COMMAND_MESSAGE, EVENT_MESSAGE, DOCUMENT_MESSAGE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

