/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum MessageEndpointType implements Enumerator
{
    TRANSACTIONAL_CLIENT(0, "TRANSACTIONAL_CLIENT", "TRANSACTIONAL_CLIENT"),
    POLLING_CONSUMER(1, "POLLING_CONSUMER", "POLLING_CONSUMER"),
    EVENT_DRIVEN_CONSUMER(2, "EVENT_DRIVEN_CONSUMER", "EVENT_DRIVEN_CONSUMER"),
    IDEMPOTENT_RECEIVER(3, "IDEMPOTENT_RECEIVER", "IDEMPOTENT_RECEIVER"),
    MESSAGING_GATEWAY(4, "MESSAGING_GATEWAY", "MESSAGING_GATEWAY"),
    MESSAGING_MAPPER(5, "MESSAGING_MAPPER", "MESSAGING_MAPPER"),
    COMPETEING_CONSUMER(6, "COMPETEING_CONSUMER", "COMPETEING_CONSUMER"),
    MESSAGE_DISPATCHER(7, "MESSAGE_DISPATCHER", "MESSAGE_DISPATCHER"),
    SELECTIVE_CONSUMER(8, "SELECTIVE_CONSUMER", "SELECTIVE_CONSUMER"),
    DURABLE_SUBSCRIBER(9, "DURABLE_SUBSCRIBER", "DURABLE_SUBSCRIBER"),
    SERRVICE_ACTIVATOR(10, "SERRVICE_ACTIVATOR", "SERRVICE_ACTIVATOR");

    public static final int TRANSACTIONAL_CLIENT_VALUE = 0;
    public static final int POLLING_CONSUMER_VALUE = 1;
    public static final int EVENT_DRIVEN_CONSUMER_VALUE = 2;
    public static final int IDEMPOTENT_RECEIVER_VALUE = 3;
    public static final int MESSAGING_GATEWAY_VALUE = 4;
    public static final int MESSAGING_MAPPER_VALUE = 5;
    public static final int COMPETEING_CONSUMER_VALUE = 6;
    public static final int MESSAGE_DISPATCHER_VALUE = 7;
    public static final int SELECTIVE_CONSUMER_VALUE = 8;
    public static final int DURABLE_SUBSCRIBER_VALUE = 9;
    public static final int SERRVICE_ACTIVATOR_VALUE = 10;
    private static final MessageEndpointType[] VALUES_ARRAY;
    public static final List<MessageEndpointType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static MessageEndpointType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MessageEndpointType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static MessageEndpointType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            MessageEndpointType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static MessageEndpointType get(int value) {
        switch (value) {
            case 0: {
                return TRANSACTIONAL_CLIENT;
            }
            case 1: {
                return POLLING_CONSUMER;
            }
            case 2: {
                return EVENT_DRIVEN_CONSUMER;
            }
            case 3: {
                return IDEMPOTENT_RECEIVER;
            }
            case 4: {
                return MESSAGING_GATEWAY;
            }
            case 5: {
                return MESSAGING_MAPPER;
            }
            case 6: {
                return COMPETEING_CONSUMER;
            }
            case 7: {
                return MESSAGE_DISPATCHER;
            }
            case 8: {
                return SELECTIVE_CONSUMER;
            }
            case 9: {
                return DURABLE_SUBSCRIBER;
            }
            case 10: {
                return SERRVICE_ACTIVATOR;
            }
        }
        return null;
    }

    private MessageEndpointType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new MessageEndpointType[]{TRANSACTIONAL_CLIENT, POLLING_CONSUMER, EVENT_DRIVEN_CONSUMER, IDEMPOTENT_RECEIVER, MESSAGING_GATEWAY, MESSAGING_MAPPER, COMPETEING_CONSUMER, MESSAGE_DISPATCHER, SELECTIVE_CONSUMER, DURABLE_SUBSCRIBER, SERRVICE_ACTIVATOR};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

