/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HTTPVerb implements Enumerator
{
    GET(0, "GET", "GET"),
    PUT(1, "PUT", "PUT"),
    POST(2, "POST", "POST"),
    PATCH(3, "PATCH", "PATCH"),
    DELETE(4, "DELETE", "DELETE"),
    HEAD(5, "HEAD", "HEAD"),
    OPTIONS(6, "OPTIONS", "OPTIONS"),
    TRACE(7, "TRACE", "TRACE");

    public static final int GET_VALUE = 0;
    public static final int PUT_VALUE = 1;
    public static final int POST_VALUE = 2;
    public static final int PATCH_VALUE = 3;
    public static final int DELETE_VALUE = 4;
    public static final int HEAD_VALUE = 5;
    public static final int OPTIONS_VALUE = 6;
    public static final int TRACE_VALUE = 7;
    private static final HTTPVerb[] VALUES_ARRAY;
    public static final List<HTTPVerb> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static HTTPVerb get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HTTPVerb result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static HTTPVerb getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HTTPVerb result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static HTTPVerb get(int value) {
        switch (value) {
            case 0: {
                return GET;
            }
            case 1: {
                return PUT;
            }
            case 2: {
                return POST;
            }
            case 3: {
                return PATCH;
            }
            case 4: {
                return DELETE;
            }
            case 5: {
                return HEAD;
            }
            case 6: {
                return OPTIONS;
            }
            case 7: {
                return TRACE;
            }
        }
        return null;
    }

    private HTTPVerb(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new HTTPVerb[]{GET, PUT, POST, PATCH, DELETE, HEAD, OPTIONS, TRACE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

