/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum HTTPParameter implements Enumerator
{
    QUERY(0, "QUERY", "QUERY"),
    HEADER(1, "HEADER", "HEADER"),
    PATH(2, "PATH", "PATH"),
    COOKIE(3, "COOKIE", "COOKIE"),
    BODY(4, "BODY", "BODY");

    public static final int QUERY_VALUE = 0;
    public static final int HEADER_VALUE = 1;
    public static final int PATH_VALUE = 2;
    public static final int COOKIE_VALUE = 3;
    public static final int BODY_VALUE = 4;
    private static final HTTPParameter[] VALUES_ARRAY;
    public static final List<HTTPParameter> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static HTTPParameter get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HTTPParameter result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static HTTPParameter getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            HTTPParameter result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static HTTPParameter get(int value) {
        switch (value) {
            case 0: {
                return QUERY;
            }
            case 1: {
                return HEADER;
            }
            case 2: {
                return PATH;
            }
            case 3: {
                return COOKIE;
            }
            case 4: {
                return BODY;
            }
        }
        return null;
    }

    private HTTPParameter(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new HTTPParameter[]{QUERY, HEADER, PATH, COOKIE, BODY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

