/*
 * Decompiled with CFR 0.152.
 */
package io.mats3.test.jupiter;

import io.mats3.MatsEndpoint;
import io.mats3.MatsFactory;
import io.mats3.test.MatsTestEndpoint;
import io.mats3.test.abstractunit.AbstractMatsTestEndpoint;
import io.mats3.test.jupiter.Extension_Mats;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class Extension_MatsTestEndpoints {
    public static <R, I> Endpoint<R, I> createEndpoint(String endpointId, Class<R> replyMsgClass, Class<I> incomingMsgClass) {
        return new EndpointImpl<R, I>(endpointId, replyMsgClass, incomingMsgClass);
    }

    public static <R, S, I> EndpointWithState<R, S, I> createEndpoint(String endpointId, Class<R> replyMsgClass, Class<S> stateClass, Class<I> incomingMsgClass) {
        return new EndpointWithStateImpl<R, S, I>(endpointId, replyMsgClass, stateClass, incomingMsgClass);
    }

    public static <I> Terminator<I> createTerminator(String endpointId, Class<I> incomingMsgClass) {
        return new TerminatorImpl<I>(endpointId, incomingMsgClass);
    }

    public static <S, I> TerminatorWithState<S, I> createTerminator(String endpointId, Class<S> stateClass, Class<I> incomingMsgClass) {
        return new TerminatorWithStateImpl<S, I>(endpointId, (Class)stateClass, (Class)incomingMsgClass){};
    }

    public static <R, I> Endpoint<R, I> createEndpoint(Extension_Mats matsRule, String endpointId, Class<R> replyMsgClass, Class<I> incomingMsgClass) {
        EndpointImpl<R, I> rule_matsEndpoint = new EndpointImpl<R, I>(endpointId, replyMsgClass, incomingMsgClass);
        rule_matsEndpoint.setMatsFactory(matsRule.getMatsFactory());
        return rule_matsEndpoint;
    }

    public static <R, S, I> EndpointWithState<R, S, I> createEndpoint(Extension_Mats matsRule, String endpointId, Class<R> replyMsgClass, Class<S> stateClass, Class<I> incomingMsgClass) {
        EndpointWithStateImpl<R, S, I> rule_matsEndpoint = new EndpointWithStateImpl<R, S, I>(endpointId, replyMsgClass, stateClass, incomingMsgClass);
        rule_matsEndpoint.setMatsFactory(matsRule.getMatsFactory());
        return rule_matsEndpoint;
    }

    public static <I> Terminator<I> createTerminator(Extension_Mats matsRule, String endpointId, Class<I> incomingMsgClass) {
        TerminatorImpl<I> iTerminatorNoState = new TerminatorImpl<I>(endpointId, incomingMsgClass);
        iTerminatorNoState.setMatsFactory(matsRule.getMatsFactory());
        return iTerminatorNoState;
    }

    public static <S, I> TerminatorWithState<S, I> createTerminator(Extension_Mats matsRule, String endpointId, Class<S> stateClass, Class<I> incomingMsgClass) {
        TerminatorWithStateImpl<S, I> siTerminator = new TerminatorWithStateImpl<S, I>(endpointId, stateClass, incomingMsgClass);
        siTerminator.setMatsFactory(matsRule.getMatsFactory());
        return siTerminator;
    }

    private static class EndpointImpl<R, I>
    extends JupiterCommonsImpl<R, Void, I>
    implements Endpoint<R, I> {
        EndpointImpl(String endpointId, Class<R> replyMsgClass, Class<I> incomingMsgClass) {
            super(endpointId, replyMsgClass, Void.class, incomingMsgClass);
        }

        @Override
        public Endpoint<R, I> setProcessLambda(MatsEndpoint.ProcessSingleLambda<R, I> lambda) {
            this._processLambda = lambda;
            return this;
        }

        @Override
        @Inject
        public Endpoint<R, I> setMatsFactory(MatsFactory matsFactory) {
            this._matsFactory = matsFactory;
            return this;
        }
    }

    private static class EndpointWithStateImpl<R, S, I>
    extends JupiterCommonsImpl<R, S, I>
    implements EndpointWithState<R, S, I> {
        EndpointWithStateImpl(String endpointId, Class<R> replyMsgClass, Class<S> stateClass, Class<I> incomingMsgClass) {
            super(endpointId, replyMsgClass, stateClass, incomingMsgClass);
        }

        @Override
        public EndpointWithState<R, S, I> setProcessLambda(MatsTestEndpoint.ProcessSingleStateLambda<R, S, I> lambda) {
            this._processLambda = lambda;
            return this;
        }

        @Override
        @Inject
        public EndpointWithState<R, S, I> setMatsFactory(MatsFactory matsFactory) {
            this._matsFactory = matsFactory;
            return this;
        }
    }

    private static class TerminatorImpl<I>
    extends JupiterCommonsImpl<Void, Void, I>
    implements Terminator<I> {
        TerminatorImpl(String endpointId, Class<I> incomingMsgClass) {
            super(endpointId, Void.TYPE, Void.TYPE, incomingMsgClass);
        }

        @Override
        public Terminator<I> setProcessLambda(MatsTestEndpoint.ProcessTerminatorNoStateLambda<I> lambda) {
            this._processLambda = lambda;
            return this;
        }

        @Override
        @Inject
        public Terminator<I> setMatsFactory(MatsFactory matsFactory) {
            this._matsFactory = matsFactory;
            return this;
        }
    }

    public static interface Endpoint<R, I>
    extends MatsTestEndpoint.IEndpoint<R, I>,
    BeforeEachCallback,
    AfterEachCallback {
        public Endpoint<R, I> setProcessLambda(MatsEndpoint.ProcessSingleLambda<R, I> var1);

        public Endpoint<R, I> setMatsFactory(MatsFactory var1);
    }

    public static interface EndpointWithState<R, S, I>
    extends MatsTestEndpoint.IEndpointWithState<R, S, I>,
    BeforeEachCallback,
    AfterEachCallback {
        public EndpointWithState<R, S, I> setProcessLambda(MatsTestEndpoint.ProcessSingleStateLambda<R, S, I> var1);

        public EndpointWithState<R, S, I> setMatsFactory(MatsFactory var1);
    }

    public static interface Terminator<I>
    extends MatsTestEndpoint.ITerminator<I>,
    BeforeEachCallback,
    AfterEachCallback {
        public Terminator<I> setProcessLambda(MatsTestEndpoint.ProcessTerminatorNoStateLambda<I> var1);

        public Terminator<I> setMatsFactory(MatsFactory var1);
    }

    private static class TerminatorWithStateImpl<S, I>
    extends JupiterCommonsImpl<Void, S, I>
    implements TerminatorWithState<S, I> {
        TerminatorWithStateImpl(String endpointId, Class<S> stateClass, Class<I> incomingMsgClass) {
            super(endpointId, Void.class, stateClass, incomingMsgClass);
        }

        @Override
        public TerminatorWithState<S, I> setProcessLambda(MatsEndpoint.ProcessTerminatorLambda<S, I> lambda) {
            this._processLambda = lambda;
            return this;
        }

        @Override
        @Inject
        public TerminatorWithState<S, I> setMatsFactory(MatsFactory matsFactory) {
            this._matsFactory = matsFactory;
            return this;
        }
    }

    public static interface TerminatorWithState<S, I>
    extends MatsTestEndpoint.ITerminatorWithState<S, I>,
    BeforeEachCallback,
    AfterEachCallback {
        public TerminatorWithState<S, I> setProcessLambda(MatsEndpoint.ProcessTerminatorLambda<S, I> var1);

        public TerminatorWithState<S, I> setMatsFactory(MatsFactory var1);
    }

    private static abstract class JupiterCommonsImpl<R, S, I>
    extends AbstractMatsTestEndpoint<R, S, I>
    implements BeforeEachCallback,
    AfterEachCallback {
        protected JupiterCommonsImpl(String endpointId, Class<R> replyMsgClass, Class<S> stateClass, Class<I> incomingMsgClass) {
            super(endpointId, replyMsgClass, stateClass, incomingMsgClass);
        }

        public MatsTestEndpoint.Message<S, I> awaitInvocation() {
            this.assertProcessLambdaSetIfRelevant();
            return super.awaitInvocation();
        }

        public MatsTestEndpoint.Message<S, I> awaitInvocation(long millisToWait) {
            this.assertProcessLambdaSetIfRelevant();
            return super.awaitInvocation(millisToWait);
        }

        public List<MatsTestEndpoint.Message<S, I>> awaitInvocations(int expectedNumberOfIncomingMsgs) {
            this.assertProcessLambdaSetIfRelevant();
            return super.awaitInvocations(expectedNumberOfIncomingMsgs);
        }

        public List<MatsTestEndpoint.Message<S, I>> awaitInvocations(int expectedNumberOfIncomingMsgs, long millisToWait) {
            this.assertProcessLambdaSetIfRelevant();
            return super.awaitInvocations(expectedNumberOfIncomingMsgs, millisToWait);
        }

        private void assertProcessLambdaSetIfRelevant() {
            if (this instanceof MatsTestEndpoint.ITerminator || this instanceof MatsTestEndpoint.ITerminatorWithState) {
                return;
            }
            if (this._processLambda == null) {
                throw new IllegalStateException("The process lambda has not been set for test endpoint '" + this._endpoint.getEndpointConfig().getEndpointId() + "', and it is not a Terminator-type. Please set it using setProcessLambda() before awaitInvocation, or use a Terminator-type.");
            }
        }

        public void beforeEach(ExtensionContext context) {
            if (this._matsFactory == null) {
                Optional<Extension_Mats> matsFromContext = Extension_Mats.findFromContext(context);
                if (matsFromContext.isPresent()) {
                    this._matsFactory = matsFromContext.get().getMatsFactory();
                } else {
                    throw new IllegalStateException("MatsFactory is not set. Didn't find Extension_Mats in ExtensionContext, so couldn't get it from there either. Either set it explicitly using setMatsFactory(matsFactory), or use Extension_Mats (which adds itself to the ExtensionContext), and ensure that it is initialized before this Extension_MatsEndpoints field.");
                }
            }
            super.before();
        }

        public void afterEach(ExtensionContext context) {
            super.after();
        }
    }
}

