package io.mateu.dtos;

import java.util.Collections;
import java.util.Map;

/** Metadata for a html element */
public record TextDto(TextContainerDto container, Map<String, String> attributes, String text)
    implements ComponentMetadataDto {

  public TextDto {
    attributes = attributes != null ? Collections.unmodifiableMap(attributes) : Map.of();
  }

  @Override
  public Map<String, String> attributes() {
    return Collections.unmodifiableMap(attributes);
  }
}
