package io.mateu.dtos;

import java.util.Collections;
import java.util.List;
import lombok.Builder;

/**
 * A field in a form
 *
 * @param fieldId Field targetId
 * @param dataType Field data dataType
 * @param stereotype Field stereotype (how it is painted)
 * @param observed If a change must trigger a rules reevaluation
 * @param autofocus Set to true if you want it to be focused when rendered
 * @param label The label/label for this field
 * @param placeholder A placeholder for this field
 * @param cssClasses Css cssClasses to be applied to this field
 * @param description A help text to be used as tooltip
 * @param badges Badges which must appear close to this field
 * @param attributes Some generic attributes
 * @param colspan Colspan for this field
 */
@Builder
public record FormFieldDto(
    String fieldId,
    String dataType,
    String stereotype,
    boolean observed,
    boolean autofocus,
    String label,
    String placeholder,
    String cssClasses,
    String description,
    List<BadgeDto> badges,
    List<PairDto> attributes,
    int colspan,
    boolean rightAligned,
    boolean bold,
    List<OptionDto> options,
    RemoteCoordinatesDto remoteCoordinates,
    Object initialValue,
    boolean readOnly,
    boolean required,
    String style,
    List<ComponentDto> columns,
    ComponentDto createForm,
    ComponentDto editor,
    String onItemSelectionActionId,
    FormPositionDto formPosition,
    int sliderMin,
    int sliderMax,
    boolean stepButtonsVisible,
    double step)
    implements ComponentMetadataDto {

  public FormFieldDto {
    badges =
        Collections.unmodifiableList(badges != null ? badges : Collections.<BadgeDto>emptyList());
    attributes =
        Collections.unmodifiableList(
            attributes != null ? attributes : Collections.<PairDto>emptyList());
    options =
        Collections.unmodifiableList(
            options != null ? options : Collections.<OptionDto>emptyList());
  }

  @Override
  public List<BadgeDto> badges() {
    return Collections.unmodifiableList(badges);
  }

  @Override
  public List<PairDto> attributes() {
    return Collections.unmodifiableList(attributes);
  }

  @Override
  public List<OptionDto> options() {
    return Collections.unmodifiableList(options);
  }
}
