/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.model;

import io.markdom.common.MarkdomNodeType;
import io.markdom.model.MarkdomDocument;
import io.markdom.model.MarkdomFactory;
import io.markdom.model.choice.MarkdomNodeChoice;
import io.markdom.model.selection.MarkdomNodeChoiceSelection;
import io.markdom.model.selection.MarkdomNodeSelection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public interface MarkdomNode {
    public MarkdomNodeType getNodeType();

    default public boolean hasParent() {
        return this.getParent().isPresent();
    }

    public Optional<? extends MarkdomNode> getParent();

    public Optional<Integer> getIndex();

    default public boolean hasDocument() {
        return this.getDocument().isPresent();
    }

    public Optional<MarkdomDocument> getDocument();

    default public Boolean hasChildren() {
        return !this.getChildren().isEmpty();
    }

    default public Integer countChildren() {
        return this.getChildren().size();
    }

    default public List<? extends MarkdomNode> getChildren() {
        return Collections.emptyList();
    }

    public MarkdomFactory getFactory();

    default public void choose(MarkdomNodeChoice choice) {
        this.select(new MarkdomNodeChoiceSelection(choice));
    }

    public <Result> Result select(MarkdomNodeSelection<Result> var1);
}

