/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.json;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import java.util.Optional;
import java.util.Stack;

public abstract class AbstractJsonObjectMarkdomHandler<JsonObject, JsonArray, Result>
implements MarkdomHandler<Result> {
    private final JsonObject jsonObject = this.createObject();
    private final Stack<JsonObject> jsonObjects = new Stack();
    private final Stack<JsonArray> jsonArrays = new Stack();
    private final boolean includeSchema;
    private JsonObject currentObject;
    private JsonArray currentArray;

    public AbstractJsonObjectMarkdomHandler(boolean includeSchema) {
        this.includeSchema = includeSchema;
    }

    @Override
    public final void onDocumentBegin() {
        this.currentObject = this.jsonObject;
        if (this.includeSchema) {
            this.putString(this.currentObject, "$schema", "http://schema.markdom.io/markdom-1.0.json#");
        }
        this.putString(this.currentObject, "version", "1.0");
    }

    @Override
    public final void onBlocksBegin() {
        this.openArray();
    }

    @Override
    public final void onBlockBegin(MarkdomBlockType type) {
        this.openObject();
        this.putString(this.currentObject, "type", type.toName());
    }

    @Override
    public final void onCodeBlock(String code, Optional<String> hint) {
        this.putString(this.currentObject, "code", code);
        if (hint.isPresent()) {
            this.putString(this.currentObject, "hint", hint.get());
        }
    }

    @Override
    public final void onCommentBlock(String comment) {
        this.putString(this.currentObject, "comment", comment);
    }

    @Override
    public final void onDivisionBlock() {
    }

    @Override
    public final void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.putInteger(this.currentObject, "level", level.ordinal() + 1);
    }

    @Override
    public final void onHeadingBlockEnd(MarkdomHeadingLevel level) {
    }

    @Override
    public final void onUnorderedListBlockBegin() {
    }

    @Override
    public final void onOrderedListBlockBegin(Integer startIndex) {
        this.putInteger(this.currentObject, "startIndex", startIndex);
    }

    @Override
    public final void onUnorderedListBlockEnd() {
    }

    @Override
    public final void onOrderedListBlockEnd(Integer startIndex) {
    }

    @Override
    public final void onParagraphBlockBegin() {
    }

    @Override
    public final void onParagraphBlockEnd() {
    }

    @Override
    public final void onQuoteBlockBegin() {
    }

    @Override
    public final void onQuoteBlockEnd() {
    }

    @Override
    public final void onBlockEnd(MarkdomBlockType type) {
        this.addObject(this.currentArray, this.currentObject);
        this.closeObject();
    }

    @Override
    public final void onNextBlock() {
    }

    @Override
    public final void onBlocksEnd() {
        this.putArray(this.currentObject, "blocks", this.currentArray);
        this.closeArray();
    }

    @Override
    public final void onListItemsBegin() {
        this.openArray();
    }

    @Override
    public final void onListItemBegin() {
        this.openObject();
    }

    @Override
    public final void onListItemEnd() {
        this.addObject(this.currentArray, this.currentObject);
        this.closeObject();
    }

    @Override
    public final void onNextListItem() {
    }

    @Override
    public final void onListItemsEnd() {
        this.putArray(this.currentObject, "items", this.currentArray);
        this.closeArray();
    }

    @Override
    public final void onContentsBegin() {
        this.openArray();
    }

    @Override
    public final void onContentBegin(MarkdomContentType type) {
        this.openObject();
        this.putString(this.currentObject, "type", type.toName());
    }

    @Override
    public final void onCodeContent(String code) {
        this.putString(this.currentObject, "code", code);
    }

    @Override
    public final void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.putInteger(this.currentObject, "level", level.ordinal() + 1);
    }

    @Override
    public final void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
    }

    @Override
    public final void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.putString(this.currentObject, "uri", uri.toString());
        if (title.isPresent()) {
            this.putString(this.currentObject, "title", title.get());
        }
        if (alternative.isPresent()) {
            this.putString(this.currentObject, "alternative", alternative.get());
        }
    }

    @Override
    public final void onLineBreakContent(Boolean hard) {
        this.putBoolean(this.currentObject, "hard", hard);
    }

    @Override
    public final void onLinkContentBegin(String uri, Optional<String> title) {
        this.putString(this.currentObject, "uri", uri);
        if (title.isPresent()) {
            this.putString(this.currentObject, "title", title.get());
        }
    }

    @Override
    public final void onLinkContentEnd(String uri, Optional<String> title) {
    }

    @Override
    public final void onTextContent(String text) {
        this.putString(this.currentObject, "text", text);
    }

    @Override
    public final void onContentEnd(MarkdomContentType type) {
        this.addObject(this.currentArray, this.currentObject);
        this.closeObject();
    }

    @Override
    public final void onNextContent() {
    }

    @Override
    public final void onContentsEnd() {
        this.putArray(this.currentObject, "contents", this.currentArray);
        this.closeArray();
    }

    @Override
    public final void onDocumentEnd() {
    }

    @Override
    public final Result getResult() {
        return this.toResult(this.jsonObject);
    }

    private JsonObject openObject() {
        this.jsonObjects.push(this.currentObject);
        this.currentObject = this.createObject();
        return this.currentObject;
    }

    private void closeObject() {
        this.currentObject = this.jsonObjects.pop();
    }

    private JsonArray openArray() {
        this.jsonArrays.push(this.currentArray);
        this.currentArray = this.createArray();
        return this.currentArray;
    }

    private void closeArray() {
        this.currentArray = this.jsonArrays.pop();
    }

    protected abstract JsonObject createObject();

    protected abstract JsonArray createArray();

    protected abstract void putBoolean(JsonObject var1, String var2, Boolean var3);

    protected abstract void putInteger(JsonObject var1, String var2, Integer var3);

    protected abstract void putString(JsonObject var1, String var2, String var3);

    protected abstract void putArray(JsonObject var1, String var2, JsonArray var3);

    protected abstract void addObject(JsonArray var1, JsonObject var2);

    protected abstract Result toResult(JsonObject var1);
}

