/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.AbstractMarkdomAudit;
import io.markdom.util.ObjectHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Optional;
import java.util.function.Consumer;

public final class ParameterMarkdomAudit
extends AbstractMarkdomAudit {
    private final Consumer<String> violationConsumer;

    public ParameterMarkdomAudit(Consumer<String> violationConsumer) {
        this.violationConsumer = (Consumer)ObjectHelper.notNull((String)"violation consumer", violationConsumer);
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        this.isNotNull("code", code);
        this.isNotNull("hint optional ", hint);
        this.hasNoLineBreak("hint", hint);
    }

    @Override
    public void onHeadingBlock(MarkdomHeadingLevel level) {
        this.isNotNull("level", (Object)level);
    }

    @Override
    public void onOrderedListBlock(Integer startIndex) {
        this.isNotNull("start index", startIndex);
        this.isNotNegative("start index", startIndex);
    }

    @Override
    public void onCodeContent(String code) {
        this.isNotNull("code", code);
        this.hasNoLineBreak("code", code);
    }

    @Override
    public void onEmphasisContent(MarkdomEmphasisLevel level) {
        this.isNotNull("level", (Object)level);
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.isNotNull("uri", uri);
        this.isValidUri("uri", uri);
        this.isNotNull("title optional", title);
        this.hasNoLineBreak("title", title);
        this.isNotNull("alternative optional", alternative);
        this.hasNoLineBreak("alternative", alternative);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.isNotNull("hard", hard);
    }

    @Override
    public void onLinkContent(String uri, Optional<String> title) {
        this.isNotNull("uri", uri);
        this.isValidUri("uri", uri);
        this.isNotNull("title optional", title);
        this.hasNoLineBreak("title", title);
    }

    @Override
    public void onTextContent(String text) {
        this.isNotNull("text", text);
        this.hasNoLineBreak("text", text);
    }

    private void isNotNull(String name, Object value) {
        if (null == value) {
            this.violationConsumer.accept("The given " + name + " is null");
        }
    }

    private void isNotNegative(String name, Integer value) {
        if (value < 0) {
            this.violationConsumer.accept("The given " + name + " is negative");
        }
    }

    private void hasNoLineBreak(String name, Optional<String> optional) {
        optional.ifPresent(value -> this.hasNoLineBreak(name, (String)value));
    }

    private void hasNoLineBreak(String name, String value) {
        if (-1 != value.indexOf(10)) {
            this.violationConsumer.accept("The given " + name + " contains a line break: " + value);
        }
    }

    private void isValidUri(String name, String uri) {
        try {
            new URI(uri);
        }
        catch (URISyntaxException e) {
            this.violationConsumer.accept("The given " + name + " is not a valid URI: " + uri);
        }
    }
}

