/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.AbstractMarkdomHandler;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Optional;
import java.util.regex.Pattern;

public final class LoggingMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final Appendable appendable;
    private final MarkdomHandler<Result> handler;
    private int depth;

    public LoggingMarkdomHandler(Appendable appendable) {
        this(appendable, new AbstractMarkdomHandler<Result>(){});
    }

    public LoggingMarkdomHandler(Appendable appendable, MarkdomHandler<Result> handler) {
        this.appendable = (Appendable)ObjectHelper.notNull((String)"appendable", (Object)appendable);
        this.handler = (MarkdomHandler)ObjectHelper.notNull((String)"handler", handler);
    }

    @Override
    public void onDocumentBegin() {
        this.appendOpeningLine("onDocumentBegin()");
        this.handler.onDocumentBegin();
    }

    @Override
    public void onBlocksBegin() {
        this.appendOpeningLine("onBlocksBegin()");
        this.handler.onBlocksBegin();
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
        this.appendLeafLine("onBlockBegin(" + this.name(type) + ")");
        this.handler.onBlockBegin(type);
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        this.appendLeafLine("onCodeBlock(" + this.quote(code) + ", " + this.quote(hint) + ")");
        this.handler.onCodeBlock(code, hint);
    }

    @Override
    public void onCommentBlock(String comment) {
        this.appendLeafLine("onCommentBlock(" + this.quote(comment) + ")");
        this.handler.onCommentBlock(comment);
    }

    @Override
    public void onDivisionBlock() {
        this.appendLeafLine("onDivisionBlock()");
        this.handler.onDivisionBlock();
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.appendOpeningLine("onHeadingBlockBegin(" + this.name(level) + ")");
        this.handler.onHeadingBlockBegin(level);
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.appendClosingLine("onHeadingBlockEnd(" + this.name(level) + ")");
        this.handler.onHeadingBlockEnd(level);
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        this.appendOpeningLine("onOrderedListBlockBegin(" + startIndex + ")");
        this.handler.onOrderedListBlockBegin(startIndex);
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        this.appendClosingLine("onOrderedListBlockEnd(" + startIndex + ")");
        this.handler.onOrderedListBlockEnd(startIndex);
    }

    @Override
    public void onParagraphBlockBegin() {
        this.appendOpeningLine("onParagraphBlockBegin()");
        this.handler.onParagraphBlockBegin();
    }

    @Override
    public void onParagraphBlockEnd() {
        this.appendClosingLine("onParagraphBlockEnd()");
        this.handler.onParagraphBlockEnd();
    }

    @Override
    public void onQuoteBlockBegin() {
        this.appendOpeningLine("onQuoteBlockBegin()");
        this.handler.onQuoteBlockBegin();
    }

    @Override
    public void onQuoteBlockEnd() {
        this.appendClosingLine("onQuoteBlockEnd()");
        this.handler.onQuoteBlockEnd();
    }

    @Override
    public void onUnorderedListBlockBegin() {
        this.appendOpeningLine("onUnorderedListBlockBegin()");
        this.handler.onUnorderedListBlockBegin();
    }

    @Override
    public void onUnorderedListBlockEnd() {
        this.appendClosingLine("onUnorderedListBlockEnd()");
        this.handler.onUnorderedListBlockEnd();
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
        this.appendLeafLine("onBlockEnd(" + this.name(type) + ")");
        this.handler.onBlockEnd(type);
    }

    @Override
    public void onNextBlock() {
        this.appendLeafLine("onNextBlock()", -1);
        this.handler.onNextBlock();
    }

    @Override
    public void onBlocksEnd() {
        this.appendClosingLine("onBlocksEnd()");
        this.handler.onBlocksEnd();
    }

    @Override
    public void onListItemsBegin() {
        this.appendOpeningLine("onListItemsBegin()");
        this.handler.onListItemsBegin();
    }

    @Override
    public void onListItemBegin() {
        this.appendOpeningLine("onListItemBegin()");
        this.handler.onListItemBegin();
    }

    @Override
    public void onListItemEnd() {
        this.appendClosingLine("onListItemEnd()");
        this.handler.onListItemEnd();
    }

    @Override
    public void onNextListItem() {
        this.appendLeafLine("onNextListItem()", -1);
        this.handler.onNextListItem();
    }

    @Override
    public void onListItemsEnd() {
        this.appendClosingLine("onListItemsEnd()");
        this.handler.onListItemsEnd();
    }

    @Override
    public void onContentsBegin() {
        this.appendOpeningLine("onContentsBegin()");
        this.handler.onContentsBegin();
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
        this.appendLeafLine("onContentBegin(" + this.name(type) + ")");
        this.handler.onContentBegin(type);
    }

    @Override
    public void onCodeContent(String code) {
        this.appendLeafLine("onCodeContent(" + this.quote(code) + ")");
        this.handler.onCodeContent(code);
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.appendOpeningLine("onEmphasisContentBegin(" + this.name(level) + ")");
        this.handler.onEmphasisContentBegin(level);
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.appendClosingLine("onEmphasisContentEnd(" + this.name(level) + ")");
        this.handler.onEmphasisContentEnd(level);
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.appendLeafLine("onImageContent(" + this.quote(uri) + ", " + this.quote(title) + ", " + this.quote(alternative) + ")");
        this.handler.onImageContent(uri, title, alternative);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.appendLeafLine("onLineBreakContent(" + hard + ")");
        this.handler.onLineBreakContent(hard);
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.appendOpeningLine("onLinkContentBegin(" + this.quote(uri) + ", " + this.quote(title) + ")");
        this.handler.onLinkContentBegin(uri, title);
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.appendClosingLine("onLinkContentEnd(" + this.quote(uri) + ", " + this.quote(title) + ")");
        this.handler.onLinkContentEnd(uri, title);
    }

    @Override
    public void onTextContent(String text) {
        this.appendLeafLine("onTextContent(" + this.quote(text) + ")");
        this.handler.onTextContent(text);
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
        this.appendLeafLine("onContentEnd(" + this.name(type) + ")");
        this.handler.onContentEnd(type);
    }

    @Override
    public void onNextContent() {
        this.appendLeafLine("onNextContent()", -1);
        this.handler.onNextContent();
    }

    @Override
    public void onContentsEnd() {
        this.appendClosingLine("onContentsEnd()");
        this.handler.onContentsEnd();
    }

    @Override
    public void onDocumentEnd() {
        this.appendClosingLine("onDocumentEnd()");
        this.handler.onDocumentEnd();
    }

    private String name(Enum<?> value) {
        return null == value ? "null" : value.name();
    }

    private String quote(Optional<?> optional) {
        return null == optional ? "null" : (optional.isPresent() ? this.quote(optional.get()) : "empty");
    }

    private String quote(Object object) {
        return null == object ? "null" : "\"" + object.toString().replaceAll(Pattern.quote("\n"), "\\\\n") + "\"";
    }

    private void appendOpeningLine(String line) {
        this.appendable.append(this.indentation(this.depth));
        this.appendable.append(line);
        this.appendable.append("\n");
        ++this.depth;
    }

    private void appendLeafLine(String line) {
        this.appendLeafLine(line, 0);
    }

    private void appendLeafLine(String line, int offset) {
        this.appendable.append(this.indentation(Math.max(0, this.depth + offset)));
        this.appendable.append(line);
        this.appendable.append("\n");
    }

    private void appendClosingLine(String line) {
        --this.depth;
        this.appendable.append(this.indentation(this.depth));
        this.appendable.append(line);
        this.appendable.append("\n");
    }

    private String indentation(int depth) {
        return new String(new char[2 * depth]).replace("\u0000", " ");
    }

    @Override
    public Result getResult() {
        return this.handler.getResult();
    }
}

