/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomFilter;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.SimpleMarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Optional;

public final class FilteringMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final SimpleMarkdomHandler<Result> handler;
    private final MarkdomFilter filter;
    private boolean filtering;
    private int filterDepth;

    public FilteringMarkdomHandler(MarkdomHandler<Result> handler, MarkdomFilter filter) {
        this.handler = new SimpleMarkdomHandler((MarkdomHandler)ObjectHelper.notNull((String)"handler", handler));
        this.filter = (MarkdomFilter)ObjectHelper.notNull((String)"filter", (Object)filter);
    }

    @Override
    public void onDocumentBegin() {
        this.handler.onDocumentBegin();
    }

    @Override
    public void onBlocksBegin() {
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
        if (this.filtering) {
            ++this.filterDepth;
        }
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        if (!this.filtering) {
            if (this.filter.testCodeBlock(code, hint)) {
                this.filtering = true;
            } else {
                this.handler.onCodeBlock(code, hint);
            }
        }
    }

    @Override
    public void onCommentBlock(String comment) {
        if (!this.filtering) {
            if (this.filter.testCommentBlock()) {
                this.filtering = true;
            } else {
                this.handler.onCommentBlock(comment);
            }
        }
    }

    @Override
    public void onDivisionBlock() {
        if (!this.filtering) {
            if (this.filter.testDivisionBlock()) {
                this.filtering = true;
            } else {
                this.handler.onDivisionBlock();
            }
        }
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        if (!this.filtering) {
            if (this.filter.testHeadingBlock(level)) {
                this.filtering = true;
            } else {
                this.handler.onHeadingBlockBegin(level);
            }
        }
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        if (!this.filtering) {
            this.handler.onHeadingBlockEnd();
        }
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        if (!this.filtering) {
            if (this.filter.testOrderedListBlock(startIndex)) {
                this.filtering = true;
            } else {
                this.handler.onOrderedListBlockBegin(startIndex);
            }
        }
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        if (!this.filtering) {
            this.handler.onOrderedListBlockEnd();
        }
    }

    @Override
    public void onParagraphBlockBegin() {
        if (!this.filtering) {
            if (this.filter.testParagraphBlock()) {
                this.filtering = true;
            } else {
                this.handler.onParagraphBlockBegin();
            }
        }
    }

    @Override
    public void onParagraphBlockEnd() {
        if (!this.filtering) {
            this.handler.onParagraphBlockEnd();
        }
    }

    @Override
    public void onQuoteBlockBegin() {
        if (!this.filtering) {
            if (this.filter.testQuoteBlock()) {
                this.filtering = true;
            } else {
                this.handler.onQuoteBlockBegin();
            }
        }
    }

    @Override
    public void onQuoteBlockEnd() {
        if (!this.filtering) {
            this.handler.onQuoteBlockEnd();
        }
    }

    @Override
    public void onUnorderedListBlockBegin() {
        if (!this.filtering) {
            if (this.filter.testUnorderedListBlock()) {
                this.filtering = true;
            } else {
                this.handler.onUnorderedListBlockBegin();
            }
        }
    }

    @Override
    public void onUnorderedListBlockEnd() {
        if (!this.filtering) {
            this.handler.onUnorderedListBlockEnd();
        }
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
        if (this.filtering) {
            if (0 == this.filterDepth) {
                this.filtering = false;
            } else {
                --this.filterDepth;
            }
        }
    }

    @Override
    public void onNextBlock() {
    }

    @Override
    public void onBlocksEnd() {
    }

    @Override
    public void onListItemsBegin() {
    }

    @Override
    public void onListItemBegin() {
        if (!this.filtering) {
            this.handler.onListItemBegin();
        }
    }

    @Override
    public void onListItemEnd() {
        if (!this.filtering) {
            this.handler.onListItemEnd();
        }
    }

    @Override
    public void onNextListItem() {
    }

    @Override
    public void onListItemsEnd() {
    }

    @Override
    public void onContentsBegin() {
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
        if (this.filtering) {
            ++this.filterDepth;
        }
    }

    @Override
    public void onCodeContent(String code) {
        if (!this.filtering) {
            if (this.filter.testCodeContent(code)) {
                this.filtering = true;
            } else {
                this.handler.onCodeContent(code);
            }
        }
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        if (!this.filtering) {
            if (this.filter.testEmphasisContent(level)) {
                this.filtering = true;
            } else {
                this.handler.onEmphasisContentBegin(level);
            }
        }
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        if (!this.filtering) {
            this.handler.onEmphasisContentEnd();
        }
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        if (!this.filtering) {
            if (this.filter.testImageContent(uri, title, alternative)) {
                this.filtering = true;
            } else {
                this.handler.onImageContent(uri, title, alternative);
            }
        }
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        if (!this.filtering) {
            if (this.filter.testLineBreakContent(hard)) {
                this.filtering = true;
            } else {
                this.handler.onLineBreakContent(hard);
            }
        }
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        if (!this.filtering) {
            if (this.filter.testLinkContent(uri, title)) {
                this.filtering = true;
            } else {
                this.handler.onLinkContentBegin(uri, title);
            }
        }
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        if (!this.filtering) {
            this.handler.onLinkContentEnd();
        }
    }

    @Override
    public void onTextContent(String text) {
        if (!this.filtering) {
            if (this.filter.testTextContent(text)) {
                this.filtering = true;
            } else {
                this.handler.onTextContent(text);
            }
        }
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
        if (this.filtering) {
            if (0 == this.filterDepth) {
                this.filtering = false;
            } else {
                --this.filterDepth;
            }
        }
    }

    @Override
    public void onNextContent() {
    }

    @Override
    public void onContentsEnd() {
    }

    @Override
    public void onDocumentEnd() {
        this.handler.onDocumentEnd();
    }

    @Override
    public Result getResult() {
        return this.handler.getResult();
    }
}

