/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomException;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.AuditingMarkdomHandler;
import io.markdom.handler.MarkdomAudit;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.ParameterMarkdomAudit;
import io.markdom.util.ObjectHelper;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Stack;
import net.markenwerk.commons.iterables.ConvertingIterable;

public final class DebuggingMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final MarkdomAudit audit = new ParameterMarkdomAudit(violation -> {
        throw new MarkdomException((String)violation);
    });
    private final MarkdomHandler<Result> handler;
    private final Stack<Context> contexts = new Stack();
    private final Stack<Queue<Object>> parameterFrames = new Stack();
    private final EnumSet<Method> expectedMethods = EnumSet.noneOf(Method.class);

    public DebuggingMarkdomHandler(MarkdomHandler<Result> handler) {
        this.handler = new AuditingMarkdomHandler((MarkdomHandler)ObjectHelper.notNull((String)"handler", handler), this.audit);
        this.expectMethods(Method.ON_DOCUMENT_BEGIN);
    }

    @Override
    public void onDocumentBegin() {
        this.isExpectedMethod(Method.ON_DOCUMENT_BEGIN);
        this.expectMethods(Method.ON_BLOCKS_BEGIN);
        this.openContext(Context.DOCUMENT);
        this.handler.onDocumentBegin();
    }

    @Override
    public void onBlocksBegin() {
        this.isExpectedMethod(Method.ON_BLOCKS_BEGIN);
        this.expectMethods(Method.ON_BLOCK_BEGIN, Method.ON_BLOCKS_END);
        this.handler.onBlocksBegin();
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
        this.isExpectedMethod(Method.ON_BLOCK_BEGIN);
        this.expectMethods(this.blockBeginCallback(type));
        this.openParameterFrame();
        this.handler.onBlockBegin(this.storeParameter(type));
    }

    private Method blockBeginCallback(MarkdomBlockType type) {
        switch (type) {
            case CODE: {
                return Method.ON_CODE_BLOCK;
            }
            case COMMENT: {
                return Method.ON_COMMENT_BLOCK;
            }
            case DIVISION: {
                return Method.ON_DIVISION_BLOCK;
            }
            case HEADING: {
                return Method.ON_HEADING_BLOCK_BEGIN;
            }
            case ORDERED_LIST: {
                return Method.ON_ORDERED_LIST_BLOCK_BEGIN;
            }
            case PARAGRAPH: {
                return Method.ON_PARAGRAPH_BLOCK_BEGIN;
            }
            case QUOTE: {
                return Method.ON_QUOTE_BLOCK_BEGIN;
            }
            case UNORDERED_LIST: {
                return Method.ON_UNORDERED_LIST_BLOCK_BEGIN;
            }
        }
        throw new InternalError("Unexpected block type: " + (Object)((Object)type));
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
        this.isExpectedMethod(Method.ON_BLOCK_END);
        this.expectMethods(Method.ON_NEXT_BLOCK, Method.ON_BLOCKS_END);
        this.handler.onBlockEnd(this.restoreParameter("type", type));
        this.closeParameterFrame();
    }

    @Override
    public void onNextBlock() {
        this.isExpectedMethod(Method.ON_NEXT_BLOCK);
        this.expectMethods(Method.ON_BLOCK_BEGIN);
        this.handler.onNextBlock();
    }

    @Override
    public void onBlocksEnd() {
        this.isExpectedMethod(Method.ON_BLOCKS_END);
        this.expectMethods(this.blocksEndCallback(this.contexts.peek()));
        this.handler.onBlocksEnd();
    }

    private Method blocksEndCallback(Context context) {
        switch (context) {
            case DOCUMENT: {
                return Method.ON_DOCUMENT_END;
            }
            case LIST_ITEM: {
                return Method.ON_LIST_ITEM_END;
            }
            case QUOTE_BLOCK: {
                return Method.ON_QUOTE_BLOCK_END;
            }
        }
        throw new InternalError("Unexpected blocks end context: " + (Object)((Object)context));
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        this.isExpectedMethod(Method.ON_CODE_BLOCK);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onCodeBlock(code, hint);
    }

    @Override
    public void onCommentBlock(String comment) {
        this.isExpectedMethod(Method.ON_COMMENT_BLOCK);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onCommentBlock(comment);
    }

    @Override
    public void onDivisionBlock() {
        this.isExpectedMethod(Method.ON_DIVISION_BLOCK);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onDivisionBlock();
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.isExpectedMethod(Method.ON_HEADING_BLOCK_BEGIN);
        this.expectMethods(Method.ON_CONTENTS_BEGIN);
        this.openParameterFrame();
        this.openContext(Context.HEADING_BLOCK);
        this.handler.onHeadingBlockBegin(this.storeParameter(level));
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.isExpectedMethod(Method.ON_HEADING_BLOCK_END);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onHeadingBlockEnd(this.restoreParameter("level", level));
        this.closeParameterFrame();
        this.closeContext();
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        this.isExpectedMethod(Method.ON_ORDERED_LIST_BLOCK_BEGIN);
        this.expectMethods(Method.ON_LIST_ITEMS_BEGIN);
        this.openParameterFrame();
        this.openContext(Context.ORDERED_LIST_BLOCK);
        this.handler.onOrderedListBlockBegin(this.storeParameter(startIndex));
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        this.isExpectedMethod(Method.ON_ORDERED_LIST_BLOCK_END);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onOrderedListBlockEnd(this.restoreParameter("start index", startIndex));
        this.closeParameterFrame();
        this.closeContext();
    }

    @Override
    public void onParagraphBlockBegin() {
        this.isExpectedMethod(Method.ON_PARAGRAPH_BLOCK_BEGIN);
        this.expectMethods(Method.ON_CONTENTS_BEGIN);
        this.openContext(Context.PARAGRAPH_BLOCK);
        this.handler.onParagraphBlockBegin();
    }

    @Override
    public void onParagraphBlockEnd() {
        this.isExpectedMethod(Method.ON_PARAGRAPH_BLOCK_END);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onParagraphBlockEnd();
        this.closeContext();
    }

    @Override
    public void onQuoteBlockBegin() {
        this.openContext(Context.QUOTE_BLOCK);
        this.isExpectedMethod(Method.ON_QUOTE_BLOCK_BEGIN);
        this.expectMethods(Method.ON_BLOCKS_BEGIN);
        this.handler.onQuoteBlockBegin();
    }

    @Override
    public void onQuoteBlockEnd() {
        this.isExpectedMethod(Method.ON_QUOTE_BLOCK_END);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onQuoteBlockEnd();
        this.closeContext();
    }

    @Override
    public void onUnorderedListBlockBegin() {
        this.openContext(Context.UNORDERED_LIST_BLOCK);
        this.isExpectedMethod(Method.ON_UNORDERED_LIST_BLOCK_BEGIN);
        this.expectMethods(Method.ON_LIST_ITEMS_BEGIN);
        this.handler.onUnorderedListBlockBegin();
    }

    @Override
    public void onUnorderedListBlockEnd() {
        this.isExpectedMethod(Method.ON_UNORDERED_LIST_BLOCK_END);
        this.expectMethods(Method.ON_BLOCK_END);
        this.handler.onUnorderedListBlockEnd();
        this.closeContext();
    }

    @Override
    public void onListItemsBegin() {
        this.isExpectedMethod(Method.ON_LIST_ITEMS_BEGIN);
        this.expectMethods(Method.ON_LIST_ITEM_BEGIN, Method.ON_LIST_ITEMS_END);
        this.handler.onListItemsBegin();
    }

    @Override
    public void onListItemBegin() {
        this.openContext(Context.LIST_ITEM);
        this.isExpectedMethod(Method.ON_LIST_ITEM_BEGIN);
        this.expectMethods(Method.ON_BLOCKS_BEGIN);
        this.handler.onListItemBegin();
    }

    @Override
    public void onListItemEnd() {
        this.isExpectedMethod(Method.ON_LIST_ITEM_END);
        this.expectMethods(Method.ON_NEXT_LIST_ITEM, Method.ON_LIST_ITEMS_END);
        this.handler.onListItemEnd();
        this.closeContext();
    }

    @Override
    public void onNextListItem() {
        this.isExpectedMethod(Method.ON_NEXT_LIST_ITEM);
        this.expectMethods(Method.ON_LIST_ITEM_BEGIN);
        this.handler.onNextListItem();
    }

    @Override
    public void onListItemsEnd() {
        this.isExpectedMethod(Method.ON_LIST_ITEMS_END);
        this.expectMethods(this.listItemEndCallback(this.contexts.peek()));
        this.handler.onListItemsEnd();
    }

    private Method listItemEndCallback(Context context) {
        switch (context) {
            case ORDERED_LIST_BLOCK: {
                return Method.ON_ORDERED_LIST_BLOCK_END;
            }
            case UNORDERED_LIST_BLOCK: {
                return Method.ON_UNORDERED_LIST_BLOCK_END;
            }
        }
        throw new InternalError("Unexpected imtem end context: " + (Object)((Object)context));
    }

    @Override
    public void onContentsBegin() {
        this.isExpectedMethod(Method.ON_CONTENTS_BEGIN);
        this.expectMethods(Method.ON_CONTENT_BEGIN, Method.ON_CONTENTS_END);
        this.handler.onContentsBegin();
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
        this.isExpectedMethod(Method.ON_CONTENT_BEGIN);
        this.expectMethods(this.contentBeginCallback(type));
        this.openParameterFrame();
        this.handler.onContentBegin(this.storeParameter(type));
    }

    private Method contentBeginCallback(MarkdomContentType type) {
        switch (type) {
            case CODE: {
                return Method.ON_CODE_CONTENT;
            }
            case EMPHASIS: {
                return Method.ON_EMPHASIS_CONTENT_BEGIN;
            }
            case IMAGE: {
                return Method.ON_IMAGE_CONTENT;
            }
            case LINE_BREAK: {
                return Method.ON_LINE_BREAK_CONTENT;
            }
            case LINK: {
                return Method.ON_LINK_CONTENT_BEGIN;
            }
            case TEXT: {
                return Method.ON_TEXT_CONTENT;
            }
        }
        throw new InternalError("Unexpected content type: " + (Object)((Object)type));
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
        this.isExpectedMethod(Method.ON_CONTENT_END);
        this.expectMethods(Method.ON_NEXT_CONTENT, Method.ON_CONTENTS_END);
        this.handler.onContentEnd(this.restoreParameter("type", type));
        this.closeParameterFrame();
    }

    @Override
    public void onNextContent() {
        this.isExpectedMethod(Method.ON_NEXT_CONTENT);
        this.expectMethods(Method.ON_CONTENT_BEGIN);
        this.handler.onNextContent();
    }

    @Override
    public void onContentsEnd() {
        this.isExpectedMethod(Method.ON_CONTENTS_END);
        this.expectMethods(this.contentsEndCallback(this.contexts.peek()));
        this.handler.onContentsEnd();
    }

    private Method contentsEndCallback(Context context) {
        switch (context) {
            case HEADING_BLOCK: {
                return Method.ON_HEADING_BLOCK_END;
            }
            case PARAGRAPH_BLOCK: {
                return Method.ON_PARAGRAPH_BLOCK_END;
            }
            case EMPHASIS_CONTENT: {
                return Method.ON_EMPHASIS_CONTENT_END;
            }
            case LINK_CONTENT: {
                return Method.ON_LINK_CONTENT_END;
            }
        }
        throw new InternalError("Unexpected contents end context: " + (Object)((Object)context));
    }

    @Override
    public void onCodeContent(String code) {
        this.isExpectedMethod(Method.ON_CODE_CONTENT);
        this.expectMethods(Method.ON_CONTENT_END);
        this.handler.onCodeContent(code);
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.isExpectedMethod(Method.ON_EMPHASIS_CONTENT_BEGIN);
        this.expectMethods(Method.ON_CONTENTS_BEGIN);
        this.openParameterFrame();
        this.openContext(Context.EMPHASIS_CONTENT);
        this.handler.onEmphasisContentBegin(this.storeParameter(level));
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.isExpectedMethod(Method.ON_EMPHASIS_CONTENT_END);
        this.expectMethods(Method.ON_CONTENT_END);
        this.handler.onEmphasisContentEnd(this.restoreParameter("level", level));
        this.closeParameterFrame();
        this.closeContext();
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.isExpectedMethod(Method.ON_IMAGE_CONTENT);
        this.expectMethods(Method.ON_CONTENT_END);
        this.handler.onImageContent(uri, title, alternative);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.isExpectedMethod(Method.ON_LINE_BREAK_CONTENT);
        this.expectMethods(Method.ON_CONTENT_END);
        this.checkLineBreakInContext();
        this.handler.onLineBreakContent(hard);
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.isExpectedMethod(Method.ON_LINK_CONTENT_BEGIN);
        this.expectMethods(Method.ON_CONTENTS_BEGIN);
        this.openParameterFrame();
        this.checkLinkContentInContext();
        this.openContext(Context.LINK_CONTENT);
        this.handler.onLinkContentBegin(this.storeParameter(uri), this.storeParameter(title));
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.isExpectedMethod(Method.ON_LINK_CONTENT_END);
        this.expectMethods(Method.ON_CONTENT_END);
        this.handler.onLinkContentEnd(this.restoreParameter("uri", uri), this.restoreParameter("title optional", title));
        this.closeParameterFrame();
        this.closeContext();
    }

    @Override
    public void onTextContent(String text) {
        this.isExpectedMethod(Method.ON_TEXT_CONTENT);
        this.expectMethods(Method.ON_CONTENT_END);
        this.handler.onTextContent(text);
    }

    @Override
    public void onDocumentEnd() {
        this.isExpectedMethod(Method.ON_DOCUMENT_END);
        this.expectMethods(Method.ON_RESULT);
        this.handler.onDocumentEnd();
    }

    @Override
    public Result getResult() {
        this.isExpectedMethod(Method.ON_RESULT);
        return this.handler.getResult();
    }

    private void openContext(Context context) {
        this.contexts.push(context);
    }

    private void checkLineBreakInContext() {
        if (this.contexts.contains((Object)Context.HEADING_BLOCK)) {
            throw new MarkdomException("A line break appeared inside a heading block");
        }
    }

    private void checkLinkContentInContext() {
        if (this.contexts.contains((Object)Context.LINK_CONTENT)) {
            throw new MarkdomException("A link content appeared inside of another link content");
        }
    }

    private void closeContext() {
        this.contexts.pop();
    }

    private void isExpectedMethod(Method method) {
        if (!this.expectedMethods.contains((Object)method)) {
            throw new MarkdomException("The invoked method is none of " + this.expectedMethods() + ": " + method.getSignature());
        }
    }

    private String expectedMethods() {
        return String.join((CharSequence)", ", (Iterable<? extends CharSequence>)new ConvertingIterable(this.expectedMethods, Method::getSignature));
    }

    private void expectMethods(Method ... methods) {
        this.expectedMethods.clear();
        for (Method method : methods) {
            this.expectedMethods.add(method);
        }
    }

    private void openParameterFrame() {
        this.parameterFrames.push(new LinkedList());
    }

    private <Value> Value storeParameter(Value value) {
        this.parameterFrames.peek().add(value);
        return value;
    }

    private <Value> Value restoreParameter(String name, Value value) {
        Object storedValue = this.parameterFrames.peek().remove();
        if (!Objects.equals(value, storedValue)) {
            throw new MarkdomException("The given " + name + " is not equal to " + storedValue + ": " + value);
        }
        return value;
    }

    private void closeParameterFrame() {
        this.parameterFrames.pop();
    }

    private static enum Method {
        ON_DOCUMENT_BEGIN("onDocumentBegin()"),
        ON_DOCUMENT_END("onDocumentEnd()"),
        ON_BLOCKS_BEGIN("onBlocksBegin()"),
        ON_BLOCK_BEGIN("onBlockBegin(MarkdomBlockType)"),
        ON_BLOCK_END("onBlockEnd(MarkdomBlockType)"),
        ON_NEXT_BLOCK("onNextBlock()"),
        ON_BLOCKS_END("onBlocksEnd()"),
        ON_CODE_BLOCK("onCodeBlock(String, Optional<String>)"),
        ON_COMMENT_BLOCK("onCommentBlock(String)"),
        ON_DIVISION_BLOCK("onDivisionBlock()"),
        ON_HEADING_BLOCK_BEGIN("onHeadingBlock(MarkdomHeadingLevel)"),
        ON_HEADING_BLOCK_END("onHeadingBlockEnd(MarkdomHeadingLevel)"),
        ON_ORDERED_LIST_BLOCK_BEGIN("onOrderedListBlockBegin(Integer)"),
        ON_ORDERED_LIST_BLOCK_END("onOrderedListBlockEnd(Integer)"),
        ON_PARAGRAPH_BLOCK_BEGIN("onParagraphBlockBegin()"),
        ON_PARAGRAPH_BLOCK_END("onParagraphBlockEnd()"),
        ON_QUOTE_BLOCK_BEGIN("onQuoteBlockBegin()"),
        ON_QUOTE_BLOCK_END("onQuoteBlockEnd()"),
        ON_UNORDERED_LIST_BLOCK_BEGIN("onUnorderedListBlockBegin()"),
        ON_UNORDERED_LIST_BLOCK_END("onUnorderedListBlockEnd()"),
        ON_LIST_ITEMS_BEGIN("onListItemsBegin()"),
        ON_LIST_ITEM_BEGIN("onListItemBegin()"),
        ON_LIST_ITEM_END("onListItemEnd()"),
        ON_NEXT_LIST_ITEM("onNextListItem()"),
        ON_LIST_ITEMS_END("onListItemsEnd()"),
        ON_CONTENTS_BEGIN("onContentsBegin()"),
        ON_CONTENT_BEGIN("onContentBegin()"),
        ON_CONTENT_END("onContentEnd()"),
        ON_NEXT_CONTENT("onNExtContent()"),
        ON_CONTENTS_END("onContentsEnd()"),
        ON_CODE_CONTENT("onCodeContent(String)"),
        ON_EMPHASIS_CONTENT_BEGIN("onEmphasisContentBegin(MarkdomEmphasisLevel)"),
        ON_EMPHASIS_CONTENT_END("onEmphasisContentEnd(markdomEmphasisLevel)"),
        ON_IMAGE_CONTENT("onImageContent(String, Optional<String>, Oprional<String>)"),
        ON_LINE_BREAK_CONTENT("onLineBreakContent(Boolean)"),
        ON_LINK_CONTENT_BEGIN("onLinkContentBegin(String, Optional<String)"),
        ON_LINK_CONTENT_END("onLinkContentEnd(String, Optional<String>)"),
        ON_TEXT_CONTENT("onTextContent(String)"),
        ON_RESULT("onResult()");

        private final String signature;

        private Method(String signature) {
            this.signature = signature;
        }

        public String getSignature() {
            return this.signature;
        }
    }

    private static enum Context {
        DOCUMENT,
        HEADING_BLOCK,
        PARAGRAPH_BLOCK,
        QUOTE_BLOCK,
        ORDERED_LIST_BLOCK,
        UNORDERED_LIST_BLOCK,
        LIST_ITEM,
        EMPHASIS_CONTENT,
        LINK_CONTENT;

    }
}

