/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomAudit;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Optional;

public final class AuditingMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final MarkdomHandler<Result> handler;
    private final MarkdomAudit audit;

    public AuditingMarkdomHandler(MarkdomHandler<Result> handler, MarkdomAudit audit) {
        this.handler = (MarkdomHandler)ObjectHelper.notNull((String)"handler", handler);
        this.audit = (MarkdomAudit)ObjectHelper.notNull((String)"audit", (Object)audit);
    }

    @Override
    public void onDocumentBegin() {
        this.handler.onDocumentBegin();
    }

    @Override
    public void onBlocksBegin() {
        this.handler.onBlocksBegin();
    }

    @Override
    public void onBlockBegin(MarkdomBlockType type) {
        this.handler.onBlockBegin(type);
    }

    @Override
    public void onCodeBlock(String code, Optional<String> hint) {
        this.audit.onCodeBlock(code, hint);
        this.handler.onCodeBlock(code, hint);
    }

    @Override
    public void onCommentBlock(String comment) {
        this.audit.onCommentBlock();
        this.handler.onCommentBlock(comment);
    }

    @Override
    public void onDivisionBlock() {
        this.audit.onDivisionBlock();
        this.handler.onDivisionBlock();
    }

    @Override
    public void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.audit.onHeadingBlock(level);
        this.handler.onHeadingBlockBegin(level);
    }

    @Override
    public void onHeadingBlockEnd(MarkdomHeadingLevel level) {
        this.handler.onHeadingBlockEnd(level);
    }

    @Override
    public void onOrderedListBlockBegin(Integer startIndex) {
        this.audit.onOrderedListBlock(startIndex);
        this.handler.onOrderedListBlockBegin(startIndex);
    }

    @Override
    public void onOrderedListBlockEnd(Integer startIndex) {
        this.handler.onOrderedListBlockEnd(startIndex);
    }

    @Override
    public void onParagraphBlockBegin() {
        this.audit.onParagraphBlock();
        this.handler.onParagraphBlockBegin();
    }

    @Override
    public void onParagraphBlockEnd() {
        this.handler.onParagraphBlockEnd();
    }

    @Override
    public void onQuoteBlockBegin() {
        this.audit.onQuoteBlock();
        this.handler.onQuoteBlockBegin();
    }

    @Override
    public void onQuoteBlockEnd() {
        this.handler.onQuoteBlockEnd();
    }

    @Override
    public void onUnorderedListBlockBegin() {
        this.audit.onUnorderedListBlock();
        this.handler.onUnorderedListBlockBegin();
    }

    @Override
    public void onUnorderedListBlockEnd() {
        this.handler.onUnorderedListBlockEnd();
    }

    @Override
    public void onBlockEnd(MarkdomBlockType type) {
        this.handler.onBlockEnd(type);
    }

    @Override
    public void onNextBlock() {
        this.handler.onNextBlock();
    }

    @Override
    public void onBlocksEnd() {
        this.handler.onBlocksEnd();
    }

    @Override
    public void onListItemsBegin() {
        this.handler.onListItemsBegin();
    }

    @Override
    public void onListItemBegin() {
        this.handler.onListItemBegin();
    }

    @Override
    public void onListItemEnd() {
        this.handler.onListItemEnd();
    }

    @Override
    public void onNextListItem() {
        this.handler.onNextListItem();
    }

    @Override
    public void onListItemsEnd() {
        this.handler.onListItemsEnd();
    }

    @Override
    public void onContentsBegin() {
        this.handler.onContentsBegin();
    }

    @Override
    public void onContentBegin(MarkdomContentType type) {
        this.handler.onContentBegin(type);
    }

    @Override
    public void onCodeContent(String code) {
        this.audit.onCodeContent(code);
        this.handler.onCodeContent(code);
    }

    @Override
    public void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.audit.onEmphasisContent(level);
        this.handler.onEmphasisContentBegin(level);
    }

    @Override
    public void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
        this.handler.onEmphasisContentEnd(level);
    }

    @Override
    public void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.audit.onImageContent(uri, title, alternative);
        this.handler.onImageContent(uri, title, alternative);
    }

    @Override
    public void onLineBreakContent(Boolean hard) {
        this.audit.onLineBreakContent(hard);
        this.handler.onLineBreakContent(hard);
    }

    @Override
    public void onLinkContentBegin(String uri, Optional<String> title) {
        this.audit.onLinkContent(uri, title);
        this.handler.onLinkContentBegin(uri, title);
    }

    @Override
    public void onLinkContentEnd(String uri, Optional<String> title) {
        this.handler.onLinkContentEnd(uri, title);
    }

    @Override
    public void onTextContent(String text) {
        this.audit.onTextContent(text);
        this.handler.onTextContent(text);
    }

    @Override
    public void onContentEnd(MarkdomContentType type) {
        this.handler.onContentEnd(type);
    }

    @Override
    public void onNextContent() {
        this.handler.onNextContent();
    }

    @Override
    public void onContentsEnd() {
        this.handler.onContentsEnd();
    }

    @Override
    public void onDocumentEnd() {
        this.handler.onDocumentEnd();
    }

    @Override
    public Result getResult() {
        return this.handler.getResult();
    }
}

