/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.common;

import java.util.HashMap;
import java.util.Map;

public enum MarkdomBlockType {
    CODE("Code"),
    COMMENT("Comment"),
    DIVISION("Division"),
    HEADING("Heading"),
    ORDERED_LIST("OrderedList"),
    PARAGRAPH("Paragraph"),
    QUOTE("Quote"),
    UNORDERED_LIST("UnorderedList");

    private static final Map<String, MarkdomBlockType> MAP;
    private final String name;

    public String toName() {
        return this.name;
    }

    public static MarkdomBlockType fromName(String value) throws IllegalArgumentException {
        MarkdomBlockType type = MAP.get(value);
        if (null == type) {
            throw new IllegalArgumentException("There is no block type with the given string value: " + value);
        }
        return type;
    }

    private MarkdomBlockType(String name) {
        this.name = name;
    }

    static {
        MAP = new HashMap<String, MarkdomBlockType>();
        for (MarkdomBlockType type : MarkdomBlockType.values()) {
            MAP.put(type.name, type);
        }
    }
}

