/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.xml;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.util.Attributes;
import java.util.Optional;

public abstract class AbstractXmlDocumentMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    @Override
    public final void onDocumentBegin() {
        this.beginDocument(null, null, null, "Document", "1.0", "http://schema.markdom.io/markdom-1.0.xsd");
    }

    @Override
    public final void onBlocksBegin() {
    }

    @Override
    public final void onBlockBegin(MarkdomBlockType type) {
        this.pushElement(type.toName());
    }

    @Override
    public final void onCodeBlock(String code, Optional<String> hint) {
        this.setAttributes(new Attributes().add("hint", hint));
        this.setCharacterData(code);
    }

    @Override
    public final void onCommentBlock(String comment) {
        this.setCharacterData(comment);
    }

    @Override
    public final void onDivisionBlock() {
    }

    @Override
    public final void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.setAttributes(new Attributes().add("level", Integer.toString(level.ordinal() + 1)));
    }

    @Override
    public final void onHeadingBlockEnd(MarkdomHeadingLevel level) {
    }

    @Override
    public final void onOrderedListBlockBegin(Integer startIndex) {
        this.setAttributes(new Attributes().add("startIndex", Integer.toString(startIndex)));
    }

    @Override
    public final void onOrderedListBlockEnd(Integer startIndex) {
    }

    @Override
    public final void onParagraphBlockBegin() {
    }

    @Override
    public final void onParagraphBlockEnd() {
    }

    @Override
    public final void onQuoteBlockBegin() {
    }

    @Override
    public final void onQuoteBlockEnd() {
    }

    @Override
    public final void onUnorderedListBlockBegin() {
    }

    @Override
    public final void onUnorderedListBlockEnd() {
    }

    @Override
    public final void onBlockEnd(MarkdomBlockType type) {
        this.popElement();
    }

    @Override
    public final void onNextBlock() {
    }

    @Override
    public final void onBlocksEnd() {
    }

    @Override
    public final void onListItemsBegin() {
    }

    @Override
    public final void onListItemBegin() {
        this.pushElement("ListItem");
    }

    @Override
    public final void onListItemEnd() {
        this.popElement();
    }

    @Override
    public final void onNextListItem() {
    }

    @Override
    public final void onListItemsEnd() {
    }

    @Override
    public final void onContentsBegin() {
    }

    @Override
    public final void onContentBegin(MarkdomContentType type) {
        this.pushElement(type.toName());
    }

    @Override
    public final void onCodeContent(String code) {
        this.setText(code);
    }

    @Override
    public final void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.setAttributes(new Attributes().add("level", Integer.toString(level.ordinal() + 1)));
    }

    @Override
    public final void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
    }

    @Override
    public final void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.setAttributes(new Attributes().add("uri", uri).add("title", title).add("alternative", alternative));
    }

    @Override
    public final void onLineBreakContent(Boolean hard) {
        this.setAttributes(new Attributes().add("hard", Boolean.toString(hard)));
    }

    @Override
    public final void onLinkContentBegin(String uri, Optional<String> title) {
        this.setAttributes(new Attributes().add("uri", uri).add("title", title));
    }

    @Override
    public final void onLinkContentEnd(String uri, Optional<String> title) {
    }

    @Override
    public final void onTextContent(String text) {
        if (0 != text.length() && this.hasWhitespaceBorder(text)) {
            this.setCharacterData(text);
        } else {
            this.setText(text);
        }
    }

    private boolean hasWhitespaceBorder(String text) {
        return Character.isWhitespace(text.charAt(0)) || Character.isWhitespace(text.charAt(text.length() - 1));
    }

    @Override
    public final void onContentEnd(MarkdomContentType type) {
        this.popElement();
    }

    @Override
    public final void onNextContent() {
    }

    @Override
    public final void onContentsEnd() {
    }

    @Override
    public final void onDocumentEnd() {
        this.endDocument();
    }

    protected abstract void beginDocument(String var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract void pushElement(String var1);

    protected abstract void setAttributes(Attributes var1);

    protected abstract void setCharacterData(String var1);

    protected abstract void setText(String var1);

    protected abstract void popElement();

    protected abstract void endDocument();
}

