/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.xml;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomException;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomDispatcher;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.SimpleMarkdomHandler;
import io.markdom.util.ObjectHelper;
import java.util.Iterator;
import java.util.Optional;

public abstract class AbstractXmlDocumentMarkdomDispatcher<XmlElement>
implements MarkdomDispatcher {
    private SimpleMarkdomHandler<?> handler;

    @Override
    public final <Result> Result handle(MarkdomHandler<Result> handler) {
        this.handler = new SimpleMarkdomHandler((MarkdomHandler)ObjectHelper.notNull((String)"handler", handler));
        try {
            XmlElement documentElement = this.getRootElement();
            this.checkVersion(this.reqString(documentElement, "version"));
            this.document(documentElement);
            return handler.getResult();
        }
        catch (Exception e) {
            throw new MarkdomException(e);
        }
    }

    private void checkVersion(String version) {
        if (!"1.0".equals(version)) {
            throw new MarkdomException("Invalid version string: " + version);
        }
        int separatorIndex = version.indexOf(46);
        int major = Integer.parseInt(version.substring(0, separatorIndex));
        int minor = Integer.parseInt(version.substring(separatorIndex + 1));
        if (major != 1) {
            throw new MarkdomException("Unsupported major version: " + major);
        }
        if (minor < 0) {
            throw new MarkdomException("Unsupported minor version: " + minor);
        }
    }

    private void document(XmlElement documentElement) {
        this.handler.onDocumentBegin();
        this.blocks(documentElement);
        this.handler.onDocumentEnd();
    }

    private void blocks(XmlElement blockParentElement) {
        this.getElements(blockParentElement).forEachRemaining(this::block);
    }

    private void block(XmlElement blockElement) {
        MarkdomBlockType type = MarkdomBlockType.fromName(this.getName(blockElement));
        switch (type) {
            case CODE: {
                this.codeBlock(blockElement);
                return;
            }
            case COMMENT: {
                this.commentBlock(blockElement);
                return;
            }
            case DIVISION: {
                this.divisionBlock(blockElement);
                return;
            }
            case HEADING: {
                this.headingBlock(blockElement);
                return;
            }
            case ORDERED_LIST: {
                this.orderedListBlock(blockElement);
                return;
            }
            case PARAGRAPH: {
                this.paragraphBlock(blockElement);
                return;
            }
            case QUOTE: {
                this.quoteBlock(blockElement);
                return;
            }
            case UNORDERED_LIST: {
                this.unorderedListBlock(blockElement);
                return;
            }
        }
        throw new InternalError("Unexpected block type: " + (Object)((Object)type));
    }

    private void codeBlock(XmlElement blockElement) {
        String code = this.getText(blockElement);
        Optional<String> hint = this.optString(blockElement, "hint");
        this.handler.onCodeBlock(code, hint);
    }

    private void commentBlock(XmlElement blockElement) {
        String comment = this.getText(blockElement);
        this.handler.onCommentBlock(comment);
    }

    private void divisionBlock(XmlElement blockElement) {
        this.handler.onDivisionBlock();
    }

    private void headingBlock(XmlElement blockElement) {
        MarkdomHeadingLevel level = MarkdomHeadingLevel.values()[this.reqInteger(blockElement, "level") - 1];
        this.handler.onHeadingBlockBegin(level);
        this.contents(blockElement);
        this.handler.onHeadingBlockEnd();
    }

    private void orderedListBlock(XmlElement blockElement) {
        Integer startIndex = this.reqInteger(blockElement, "startIndex");
        this.handler.onOrderedListBlockBegin(startIndex);
        this.items(blockElement);
        this.handler.onOrderedListBlockEnd();
    }

    private void paragraphBlock(XmlElement blockElement) {
        this.handler.onParagraphBlockBegin();
        this.contents(blockElement);
        this.handler.onParagraphBlockEnd();
    }

    private void quoteBlock(XmlElement blockElement) {
        this.handler.onQuoteBlockBegin();
        this.blocks(blockElement);
        this.handler.onQuoteBlockEnd();
    }

    private void unorderedListBlock(XmlElement blockElement) {
        this.handler.onUnorderedListBlockBegin();
        this.items(blockElement);
        this.handler.onUnorderedListBlockEnd();
    }

    private void items(XmlElement listBlockElement) {
        this.getElements(listBlockElement).forEachRemaining(this::item);
    }

    private void item(XmlElement itemElement) {
        this.handler.onListItemBegin();
        this.blocks(itemElement);
        this.handler.onListItemEnd();
    }

    private void contents(XmlElement contentParentElement) {
        this.getElements(contentParentElement).forEachRemaining(this::content);
    }

    private void content(XmlElement contentElement) {
        MarkdomContentType type = MarkdomContentType.fromName(this.getName(contentElement));
        switch (type) {
            case CODE: {
                this.codeContent(contentElement);
                return;
            }
            case EMPHASIS: {
                this.emphasisContent(contentElement);
                return;
            }
            case IMAGE: {
                this.imageContent(contentElement);
                return;
            }
            case LINE_BREAK: {
                this.lineBreakContent(contentElement);
                return;
            }
            case LINK: {
                this.linkContent(contentElement);
                return;
            }
            case TEXT: {
                this.textContent(contentElement);
                return;
            }
        }
        throw new InternalError("Unexpected content type: " + (Object)((Object)type));
    }

    private void codeContent(XmlElement contentElement) {
        String code = this.getText(contentElement);
        this.handler.onCodeContent(code);
    }

    private void emphasisContent(XmlElement contentElement) {
        MarkdomEmphasisLevel level = MarkdomEmphasisLevel.values()[this.reqInteger(contentElement, "level") - 1];
        this.handler.onEmphasisContentBegin(level);
        this.contents(contentElement);
        this.handler.onEmphasisContentEnd();
    }

    private void imageContent(XmlElement contentElement) {
        String uri = this.reqString(contentElement, "uri");
        Optional<String> title = this.optString(contentElement, "title");
        Optional<String> alternative = this.optString(contentElement, "alternative");
        this.handler.onImageContent(uri, title, alternative);
    }

    private void lineBreakContent(XmlElement contentElement) {
        boolean hard = this.reqBoolean(contentElement, "hard");
        this.handler.onLineBreakContent(hard);
    }

    private void linkContent(XmlElement contentElement) {
        String uri = this.reqString(contentElement, "uri");
        Optional<String> title = this.optString(contentElement, "title");
        this.handler.onLinkContentBegin(uri, title);
        this.contents(contentElement);
        this.handler.onLinkContentEnd();
    }

    private void textContent(XmlElement contentElement) {
        String text = this.getText(contentElement);
        this.handler.onTextContent(text);
    }

    protected abstract XmlElement getRootElement();

    protected abstract String getName(XmlElement var1);

    protected abstract Iterator<XmlElement> getElements(XmlElement var1);

    protected abstract String getText(XmlElement var1);

    protected abstract Optional<String> optString(XmlElement var1, String var2);

    protected abstract String reqString(XmlElement var1, String var2);

    protected abstract Boolean reqBoolean(XmlElement var1, String var2);

    protected abstract Integer reqInteger(XmlElement var1, String var2);
}

