/*
 * Decompiled with CFR 0.152.
 */
package io.markdom.handler.html;

import io.markdom.common.MarkdomBlockType;
import io.markdom.common.MarkdomContentType;
import io.markdom.common.MarkdomEmphasisLevel;
import io.markdom.common.MarkdomHeadingLevel;
import io.markdom.handler.MarkdomHandler;
import io.markdom.handler.html.HtmlDelegate;
import io.markdom.util.Attributes;
import io.markdom.util.Element;
import io.markdom.util.Elements;
import io.markdom.util.ObjectHelper;
import java.util.Optional;
import java.util.Stack;

public abstract class AbstractHtmlDocumentMarkdomHandler<Result>
implements MarkdomHandler<Result> {
    private final Stack<Integer> depths = new Stack();
    private final HtmlDelegate delegate;
    private final String title;

    public AbstractHtmlDocumentMarkdomHandler(HtmlDelegate delegate, String title) {
        this.delegate = (HtmlDelegate)ObjectHelper.notNull((String)"delegate", (Object)delegate);
        this.title = (String)ObjectHelper.notNull((String)"title", (Object)title);
    }

    @Override
    public final void onDocumentBegin() {
        this.beginDocument("html", "html");
        this.pushElement("head");
        this.pushElement("title");
        this.setText(this.title);
        this.popElement();
        this.popElement();
        this.pushElement("body");
    }

    @Override
    public final void onBlocksBegin() {
    }

    @Override
    public final void onBlockBegin(MarkdomBlockType type) {
    }

    @Override
    public final void onCodeBlock(String code, Optional<String> hint) {
        this.pushElements(this.delegate.onCodeBlock(code, hint));
        this.setCharacterData(code);
    }

    @Override
    public final void onCommentBlock(String comment) {
    }

    @Override
    public final void onDivisionBlock() {
        this.pushElements(this.delegate.onDivisionBlock());
    }

    @Override
    public final void onHeadingBlockBegin(MarkdomHeadingLevel level) {
        this.pushElements(this.delegate.onHeadingBlock(level));
    }

    @Override
    public final void onHeadingBlockEnd(MarkdomHeadingLevel level) {
    }

    @Override
    public final void onOrderedListBlockBegin(Integer startIndex) {
        this.pushElements(this.delegate.onOrderdListBlock(startIndex));
    }

    @Override
    public final void onOrderedListBlockEnd(Integer startIndex) {
    }

    @Override
    public final void onParagraphBlockBegin() {
        this.pushElements(this.delegate.onParagraphBlock());
    }

    @Override
    public final void onParagraphBlockEnd() {
    }

    @Override
    public final void onQuoteBlockBegin() {
        this.pushElements(this.delegate.onQuoteBlock());
    }

    @Override
    public final void onQuoteBlockEnd() {
    }

    @Override
    public final void onUnorderedListBlockBegin() {
        this.pushElements(this.delegate.onUnorderedListBlock());
    }

    @Override
    public final void onUnorderedListBlockEnd() {
    }

    @Override
    public final void onBlockEnd(MarkdomBlockType type) {
        this.popElements();
    }

    @Override
    public final void onNextBlock() {
    }

    @Override
    public final void onBlocksEnd() {
    }

    @Override
    public final void onListItemsBegin() {
    }

    @Override
    public final void onListItemBegin() {
        this.pushElements(this.delegate.onListItem());
    }

    @Override
    public final void onListItemEnd() {
        this.popElements();
    }

    @Override
    public final void onNextListItem() {
    }

    @Override
    public final void onListItemsEnd() {
    }

    @Override
    public final void onContentsBegin() {
    }

    @Override
    public final void onContentBegin(MarkdomContentType type) {
    }

    @Override
    public final void onCodeContent(String code) {
        this.pushElements(this.delegate.onCodeContent(code));
        this.setText(code);
    }

    @Override
    public final void onEmphasisContentBegin(MarkdomEmphasisLevel level) {
        this.pushElements(this.delegate.onEmphasisContent(level));
    }

    @Override
    public final void onEmphasisContentEnd(MarkdomEmphasisLevel level) {
    }

    @Override
    public final void onImageContent(String uri, Optional<String> title, Optional<String> alternative) {
        this.pushElements(this.delegate.onImageContent(uri, title, alternative));
    }

    @Override
    public final void onLineBreakContent(Boolean hard) {
        if (hard.booleanValue()) {
            this.pushElements(this.delegate.onLineBreakContent());
        } else {
            this.pushElements(new Elements());
            this.setText(" ");
        }
    }

    @Override
    public final void onLinkContentBegin(String uri, Optional<String> title) {
        this.pushElements(this.delegate.onLinkContent(uri, title));
    }

    @Override
    public final void onLinkContentEnd(String uri, Optional<String> title) {
    }

    @Override
    public final void onTextContent(String text) {
        this.pushElements(this.delegate.onTextContent(text));
        this.setText(text);
    }

    @Override
    public final void onContentEnd(MarkdomContentType type) {
        this.popElements();
    }

    @Override
    public final void onNextContent() {
    }

    @Override
    public final void onContentsEnd() {
    }

    @Override
    public final void onDocumentEnd() {
        this.popElement();
        this.endDocument();
    }

    protected abstract void beginDocument(String var1, String var2);

    private void pushElements(Elements elements) {
        int depth = 0;
        for (Element element : elements) {
            this.pushElement(element.getTagName());
            this.setAttributes(element.getAttributes());
            ++depth;
        }
        this.depths.push(depth);
    }

    protected abstract void pushElement(String var1);

    protected abstract void setAttributes(Attributes var1);

    protected abstract void setCharacterData(String var1);

    protected abstract void setText(String var1);

    private void popElements() {
        int depth = this.depths.pop();
        for (int i = 0; i < depth; ++i) {
            this.popElement();
        }
    }

    protected abstract void popElement();

    protected abstract void endDocument();
}

