/*
 * Decompiled with CFR 0.152.
 */
package io.mangoo.test.http;

import com.google.common.collect.Multimap;
import io.mangoo.core.Application;
import io.mangoo.core.Config;
import io.mangoo.enums.Default;
import io.mangoo.enums.Required;
import io.undertow.util.Methods;
import java.io.IOException;
import java.net.Authenticator;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.HttpCookie;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TestResponse {
    private static final Logger LOG = LogManager.getLogger(TestResponse.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final int FIVE_SECONDS = 5;
    private CookieManager cookieManager = new CookieManager(null, CookiePolicy.ACCEPT_ALL);
    private HttpRequest.Builder httpRequest = HttpRequest.newBuilder().timeout(Duration.of(5L, ChronoUnit.SECONDS));
    private HttpRequest.BodyPublisher body = HttpRequest.BodyPublishers.noBody();
    private HttpClient.Builder httpClient = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).followRedirects(HttpClient.Redirect.ALWAYS).cookieHandler(this.cookieManager);
    private Authenticator authenticator;
    private HttpResponse<String> httpResponse;
    private String uri;
    private String url;
    private String method;

    public TestResponse() {
    }

    public TestResponse(String string, String string2) {
        Objects.requireNonNull(string, Required.URI.toString());
        Objects.requireNonNull(string2, Required.HTTP_METHOD.toString());
        this.uri = string;
        this.method = string2;
    }

    public TestResponse withHeader(String string, String string2) {
        Objects.requireNonNull(string, Required.NAME.toString());
        Objects.requireNonNull(string2, Required.VALUE.toString());
        this.httpRequest.header(string, string2);
        return this;
    }

    public TestResponse withHTTPMethod(String string) {
        Objects.requireNonNull(string, Required.HTTP_METHOD.toString());
        this.method = string;
        return this;
    }

    public TestResponse withTimeout(long l, TemporalUnit temporalUnit) {
        Objects.requireNonNull(this.method, Required.HTTP_METHOD.toString());
        Objects.requireNonNull(this.method, Required.UNIT.toString());
        this.httpRequest.timeout(Duration.of(l, temporalUnit));
        return this;
    }

    public TestResponse withBasicAuthentication(final String string, final String string2) {
        Objects.requireNonNull(string, Required.USERNAME.toString());
        Objects.requireNonNull(string2, Required.PASSWORD.toString());
        this.authenticator = new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(string, string2.toCharArray());
            }
        };
        return this;
    }

    public TestResponse to(String string) {
        Objects.requireNonNull(string, Required.URI.toString());
        this.uri = string;
        return this;
    }

    public TestResponse withCookie(HttpCookie httpCookie) {
        Objects.requireNonNull(httpCookie, Required.COOKIE.toString());
        this.cookieManager.getCookieStore().add(null, httpCookie);
        return this;
    }

    public TestResponse withStringBody(String string) {
        if (StringUtils.isNotBlank((CharSequence)string)) {
            this.body = HttpRequest.BodyPublishers.ofString(string);
        }
        return this;
    }

    public TestResponse withContentType(String string) {
        Objects.requireNonNull(string, Required.CONTENT_TYPE.toString());
        this.httpRequest.header(CONTENT_TYPE, string);
        return this;
    }

    public TestResponse withDisabledRedirects() {
        this.httpClient.followRedirects(HttpClient.Redirect.NEVER);
        return this;
    }

    public TestResponse withForm(Multimap<String, String> multimap) {
        String string = multimap.entries().stream().map(entry -> (String)entry.getKey() + "=" + URLEncoder.encode((String)entry.getValue(), Charset.forName(Default.ENCODING.toString()))).collect(Collectors.joining("&"));
        this.httpRequest.header(CONTENT_TYPE, "application/x-www-form-urlencoded");
        this.body = HttpRequest.BodyPublishers.ofString(string);
        this.method = Methods.POST.toString();
        return this;
    }

    public TestResponse execute() {
        Config config = (Config)Application.getInstance(Config.class);
        String string = config.getConnectorHttpHost();
        int n = config.getConnectorHttpPort();
        try {
            this.url = "http://" + string + ":" + n;
            this.httpRequest.uri(new URI(this.url + this.uri)).method(this.method, this.body);
            if (this.authenticator != null) {
                this.httpClient.authenticator(this.authenticator);
            }
            this.httpResponse = this.httpClient.build().send(this.httpRequest.build(), HttpResponse.BodyHandlers.ofString());
        }
        catch (IOException | InterruptedException | URISyntaxException exception) {
            LOG.error("Failed to execute HTTP request", (Throwable)exception);
            Thread.currentThread().interrupt();
        }
        return this;
    }

    public String getContent() {
        return this.httpResponse.body();
    }

    public HttpResponse<String> getHttpResponse() {
        return this.httpResponse;
    }

    public int getStatusCode() {
        return this.httpResponse.statusCode();
    }

    public String getContentType() {
        return this.httpResponse.headers().firstValue(CONTENT_TYPE).orElse("");
    }

    public String getResponseUrl() {
        return this.url;
    }

    public List<HttpCookie> getCookies() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    public HttpCookie getCookie(String string) {
        return this.cookieManager.getCookieStore().getCookies().stream().filter(httpCookie -> httpCookie.getName().equals(string)).findFirst().orElse(null);
    }

    public String getHeader(String string) {
        return this.httpResponse.headers().firstValue(string).orElse("");
    }
}

