/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.common.ObjectMapperHolder;
import io.manbang.ebatis.core.domain.AdditionalSource;
import io.manbang.ebatis.core.domain.MetaSource;
import io.manbang.ebatis.core.domain.ResponseMeta;
import io.manbang.ebatis.core.exception.DocumentDeserializeException;
import io.manbang.ebatis.core.response.DocumentMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.search.SearchHit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonDocumentMapper<T>
implements DocumentMapper<T> {
    private static final Logger log = LoggerFactory.getLogger(JacksonDocumentMapper.class);
    private static final Map<Class<?>, DocumentMapper<?>> MAPPERS = new ConcurrentHashMap();
    private final Class<T> entityClass;

    private JacksonDocumentMapper(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public static <T> DocumentMapper<T> of(Class<T> entityClass) {
        return MAPPERS.computeIfAbsent(entityClass, JacksonDocumentMapper::new);
    }

    @Override
    public T mapRow(SearchHit hit, int index) {
        Object document;
        try {
            document = ObjectMapperHolder.objectMapper().readValue(hit.getSourceRef().toBytesRef().bytes, this.entityClass);
        }
        catch (IOException e2) {
            log.error("\u53cd\u5e8f\u5217\u5316\u6587\u6863\u5f02\u5e38", (Throwable)e2);
            throw new DocumentDeserializeException(e2);
        }
        if (document instanceof MetaSource) {
            MetaSource source = (MetaSource)document;
            ResponseMeta meta = MetaSource.of(hit);
            source.setResponseMeta(meta);
        }
        if (document instanceof AdditionalSource) {
            Map<String, List<Object>> additionalSourceMap = hit.getFields().values().stream().map(e -> Tuple.tuple((Object)e.getName(), (Object)e.getValues())).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            AdditionalSource additionalSource = (AdditionalSource)document;
            additionalSource.setAdditionalSource(additionalSourceMap);
        }
        return (T)document;
    }

    @Override
    public Class<T> getEntityClass() {
        return this.entityClass;
    }
}

