/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.manbang.ebatis.core.annotation.Index;
import io.manbang.ebatis.core.common.ActiveShardCountUtils;
import io.manbang.ebatis.core.common.ObjectMapperHolder;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.provider.IdProvider;
import io.manbang.ebatis.core.provider.RoutingProvider;
import io.manbang.ebatis.core.provider.VersionProvider;
import io.manbang.ebatis.core.request.AbstractRequestFactory;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.client.Requests;
import org.elasticsearch.common.xcontent.XContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IndexRequestFactory
extends AbstractRequestFactory<Index, IndexRequest> {
    private static final Logger log = LoggerFactory.getLogger(IndexRequestFactory.class);
    static final IndexRequestFactory INSTANCE = new IndexRequestFactory();

    private IndexRequestFactory() {
    }

    @Override
    protected void setAnnotationMeta(IndexRequest request, Index index) {
        ((IndexRequest)((IndexRequest)((IndexRequest)request.setRefreshPolicy(index.refreshPolicy())).versionType(index.versionType()).waitForActiveShards(ActiveShardCountUtils.getActiveShardCount(index.waitForActiveShards()))).timeout(index.timeout())).opType(index.opType());
        if (StringUtils.isNotBlank((CharSequence)index.id())) {
            request.id(String.valueOf(request.sourceAsMap().get(index.id())));
        }
        request.setPipeline(StringUtils.trimToNull((String)index.pipeline()));
    }

    @Override
    protected IndexRequest doCreate(MethodMeta meta, Object[] args) {
        byte[] source;
        IndexRequest request = Requests.indexRequest((String)meta.getIndex());
        this.setTypeIfNecessary(meta, arg_0 -> ((IndexRequest)request).type(arg_0));
        Object doc = meta.getConditionParameter().getValue(args);
        ObjectMapper mapper = ObjectMapperHolder.objectMapper();
        try {
            source = mapper.writeValueAsBytes(doc);
        }
        catch (JsonProcessingException e) {
            log.error("\u6761\u4ef6\u8f6c\u6362\u6210JSON\u5b57\u8282\u6570\u7ec4\u5f02\u5e38\uff1a{}", doc, (Object)e);
            source = new byte[]{};
        }
        request.source(source, XContentType.JSON);
        if (doc instanceof IdProvider) {
            request.id(((IdProvider)doc).getId());
        }
        if (doc instanceof VersionProvider) {
            request.version(((VersionProvider)doc).getVersion());
        }
        if (doc instanceof RoutingProvider) {
            request.routing(((RoutingProvider)doc).getRouting());
        }
        return request;
    }
}

