/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import io.manbang.ebatis.core.annotation.Agg;
import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.provider.AggProvider;
import io.manbang.ebatis.core.provider.RoutingProvider;
import io.manbang.ebatis.core.request.AbstractRequestFactory;
import io.manbang.ebatis.core.request.RequestFactory;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.action.search.SearchRequest;

class AggRequestFactory
extends AbstractRequestFactory<Agg, SearchRequest> {
    public static final AggRequestFactory INSTANCE = new AggRequestFactory();

    private AggRequestFactory() {
    }

    @Override
    protected void setAnnotationMeta(SearchRequest request, Agg agg) {
        request.preference(StringUtils.trimToNull((String)agg.preference())).searchType(agg.searchType());
        if (agg.aggOnly()) {
            request.source().fetchSource(false).size(0);
        }
    }

    @Override
    protected SearchRequest doCreate(MethodMeta meta, Object[] args) {
        AggProvider aggProvider;
        Optional<ParameterMeta> conditionMeta = meta.findConditionParameter();
        Object condition = conditionMeta.map(p -> p.getValue(args)).orElse(null);
        SearchRequest request = condition != null ? RequestFactory.search().create(meta, args) : new SearchRequest(ArrayUtils.EMPTY_STRING_ARRAY);
        if (condition instanceof AggProvider && ArrayUtils.isNotEmpty((Object[])(aggProvider = (AggProvider)condition).getAggregations())) {
            for (Aggregation agg : aggProvider.getAggregations()) {
                request.source().aggregation(agg.toAggBuilder());
            }
        }
        if (condition instanceof RoutingProvider) {
            request.routing(((RoutingProvider)condition).getRouting());
        }
        return request;
    }
}

