/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.proxy;

import io.manbang.ebatis.core.annotation.Mapper;
import io.manbang.ebatis.core.exception.MapperAnnotationNotPresentException;
import io.manbang.ebatis.core.exception.MapperNotAllowInheritException;
import io.manbang.ebatis.core.exception.MapperNotInterfaceException;
import io.manbang.ebatis.core.proxy.MapperProxy;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class MapperRegistry {
    private static final Map<Class<?>, Object> PROXIES = new ConcurrentHashMap();

    private MapperRegistry() {
        throw new UnsupportedOperationException();
    }

    private static synchronized Object createProxy(Class<?> mapperInterface, ClassLoader classLoader, String clusterRouterName) {
        ClassLoader cl = classLoader == null ? mapperInterface.getClassLoader() : classLoader;
        return Proxy.newProxyInstance(cl, new Class[]{mapperInterface}, (InvocationHandler)new MapperProxy(mapperInterface, clusterRouterName));
    }

    static <M> M createIfAbsent(Class<M> mapperInterface, ClassLoader classLoader, String clusterRouterName) {
        if (!mapperInterface.isInterface()) {
            throw new MapperNotInterfaceException(mapperInterface.toString());
        }
        if (mapperInterface.getInterfaces().length > 0) {
            throw new MapperNotAllowInheritException(mapperInterface.toString());
        }
        Annotation[] annotations = mapperInterface.getAnnotations();
        boolean mapperAnnotationPresent = false;
        for (Annotation annotation : annotations) {
            boolean bl = mapperAnnotationPresent = annotation.annotationType() == Mapper.class || annotation.annotationType().isAnnotationPresent(Mapper.class);
            if (mapperAnnotationPresent) break;
        }
        if (!mapperAnnotationPresent) {
            throw new MapperAnnotationNotPresentException(mapperInterface.toString());
        }
        return (M)PROXIES.computeIfAbsent(mapperInterface, clazz -> MapperRegistry.createProxy(clazz, classLoader, clusterRouterName));
    }
}

