/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.annotation.Ignore;
import io.manbang.ebatis.core.annotation.Must;
import io.manbang.ebatis.core.builder.QueryClauseType;
import io.manbang.ebatis.core.meta.AnnotatedMeta;
import io.manbang.ebatis.core.meta.FieldMeta;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class QueryClauses {
    private QueryClauses() {
        throw new UnsupportedOperationException();
    }

    public static Class<? extends Annotation> getQueryClauseClass(AnnotatedMeta<?> meta) {
        for (QueryClauseType queryClauseType : QueryClauseType.values()) {
            Class<? extends Annotation> queryClauseClass = queryClauseType.getQueryClauseClass();
            if (!meta.isAnnotationPresent(queryClauseClass)) continue;
            return queryClauseClass;
        }
        return Must.class;
    }

    public static Map<Class<? extends Annotation>, List<FieldMeta>> groupByQueryClause(Class<?> queryClass) {
        Map metas = Arrays.stream(queryClass.getFields()).filter(QueryClauses::filterField).map(FieldMeta::of).collect(Collectors.groupingBy(FieldMeta::getQueryClauseAnnotationClass, Collectors.toList()));
        return Collections.unmodifiableMap(metas);
    }

    public static boolean filterField(Field field) {
        int modifiers = field.getModifiers();
        return Modifier.isPrivate(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isTransient(modifiers) && !field.isAnnotationPresent(Ignore.class);
    }
}

