/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class MetaUtils {
    private static final Set<Class<?>> BASIC_CLASSES = new HashSet();

    private MetaUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isBasic(Class<?> type) {
        return BASIC_CLASSES.contains(type);
    }

    public static void registerBasicClass(Class<?> clazz) {
        BASIC_CLASSES.add(clazz);
    }

    public static <E> Optional<E> findFirstElement(E[] array) {
        return array == null || array.length == 0 ? Optional.empty() : Optional.of(array[0]);
    }

    public static <E> E getFirstElement(E[] array) {
        if (array == null || array.length == 0) {
            throw new IndexOutOfBoundsException("\u6570\u7ec4\u81f3\u5c11\u9700\u8981\u4e00\u4e2a\u5143\u7d20");
        }
        return array[0];
    }

    static {
        BASIC_CLASSES.add(Boolean.TYPE);
        BASIC_CLASSES.add(Boolean.class);
        BASIC_CLASSES.add(Byte.TYPE);
        BASIC_CLASSES.add(Byte.class);
        BASIC_CLASSES.add(Short.TYPE);
        BASIC_CLASSES.add(Short.class);
        BASIC_CLASSES.add(Integer.TYPE);
        BASIC_CLASSES.add(Integer.class);
        BASIC_CLASSES.add(Long.TYPE);
        BASIC_CLASSES.add(Long.class);
        BASIC_CLASSES.add(Float.TYPE);
        BASIC_CLASSES.add(Float.class);
        BASIC_CLASSES.add(Double.TYPE);
        BASIC_CLASSES.add(Double.class);
        BASIC_CLASSES.add(String.class);
        BASIC_CLASSES.add(Date.class);
        BASIC_CLASSES.add(BigDecimal.class);
        BASIC_CLASSES.add(Calendar.class);
    }
}

