/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.AbstractSort;
import io.manbang.ebatis.core.domain.GeoDistanceSort;
import io.manbang.ebatis.core.domain.SortDirection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.geo.GeoDistance;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.index.query.GeoValidationMethod;
import org.elasticsearch.search.sort.GeoDistanceSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;

class DefaultGeoDistanceSort
extends AbstractSort
implements GeoDistanceSort {
    private final List<GeoPoint> points = new ArrayList<GeoPoint>();
    private GeoDistance geoDistance = GeoDistance.ARC;
    private DistanceUnit unit = DistanceUnit.DEFAULT;
    private GeoValidationMethod validation = GeoDistanceSortBuilder.DEFAULT_VALIDATION;
    private boolean ignoreUnmapped = false;

    DefaultGeoDistanceSort(String name, SortDirection direction) {
        super(name, direction);
    }

    @Override
    public GeoDistance geoDistance() {
        return this.geoDistance;
    }

    @Override
    public GeoDistanceSort geoDistance(GeoDistance distance) {
        this.geoDistance = distance;
        return this;
    }

    @Override
    public DistanceUnit unit() {
        return this.unit;
    }

    @Override
    public GeoDistanceSort unit(DistanceUnit unit) {
        this.unit = unit;
        return this;
    }

    @Override
    public GeoValidationMethod validation() {
        return this.validation;
    }

    @Override
    public GeoDistanceSort validation(GeoValidationMethod validation) {
        this.validation = validation;
        return this;
    }

    @Override
    public boolean ignoreUnmapped() {
        return this.ignoreUnmapped;
    }

    @Override
    public GeoDistanceSort ignoreUnmapped(boolean ignoreUnmapped) {
        this.ignoreUnmapped = ignoreUnmapped;
        return this;
    }

    @Override
    public List<GeoPoint> points() {
        return Collections.unmodifiableList(this.points);
    }

    @Override
    public GeoDistanceSort addPoint(GeoPoint point) {
        this.points.add(point);
        return this;
    }

    @Override
    public GeoDistanceSort addPoint(double lat, double lon) {
        return this.addPoint(new GeoPoint(lat, lon));
    }

    @Override
    public GeoDistanceSort addPoint(String value) {
        return this.addPoint(new GeoPoint(value));
    }

    @Override
    public SortBuilder<?> toSortBuilder() {
        GeoDistanceSortBuilder builder = (GeoDistanceSortBuilder)SortBuilders.geoDistanceSort((String)this.name(), (GeoPoint[])this.points().toArray(new GeoPoint[0])).ignoreUnmapped(this.ignoreUnmapped).geoDistance(this.geoDistance).unit(this.unit).order(this.direction().getOrder());
        this.setSortMode(arg_0 -> ((GeoDistanceSortBuilder)builder).sortMode(arg_0));
        this.setNestedSort(arg_0 -> ((GeoDistanceSortBuilder)builder).setNestedSort(arg_0));
        return builder;
    }
}

