/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.AbstractWeightedClusterLoadBalancer;
import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.Weighted;
import io.manbang.ebatis.core.cluster.WeightedCluster;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;

class SimpleWeightedClusterLoadBalancer
extends AbstractWeightedClusterLoadBalancer {
    static final SimpleWeightedClusterLoadBalancer INSTANCE = new SimpleWeightedClusterLoadBalancer();
    private static final int DISABLED_CLUSTER_WEIGHT = 0;

    private SimpleWeightedClusterLoadBalancer() {
    }

    @Override
    protected Cluster doChoose(WeightedCluster[] clusters) {
        int totalWeight = Stream.of(clusters).mapToInt(Weighted::getWeight).filter(this::isEnabled).sum();
        int randomWeight = ThreadLocalRandom.current().nextInt(totalWeight);
        for (WeightedCluster cluster : clusters) {
            if ((randomWeight -= cluster.getWeight()) >= 0) continue;
            return cluster;
        }
        return clusters[0];
    }

    private boolean isEnabled(int weight) {
        return weight > 0;
    }
}

