/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.cluster.ClusterRouterProvider;
import io.manbang.ebatis.core.exception.ClusterRouterNotFoundException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterRouterLoader {
    private static final Logger log = LoggerFactory.getLogger(ClusterRouterLoader.class);
    private static final Object $LOCK = new Object[0];
    private static final Map<String, ClusterRouter> CLUSTER_ROUTERS = new ConcurrentHashMap<String, ClusterRouter>();

    private ClusterRouterLoader() {
        throw new UnsupportedOperationException();
    }

    public static ClusterRouter getClusterRouter(String name) {
        return CLUSTER_ROUTERS.computeIfAbsent(name, ClusterRouterLoader::findClusterRouter);
    }

    private static ClusterRouter findClusterRouter(String name) {
        Object object = $LOCK;
        synchronized (object) {
            ServiceLoader<ClusterRouterProvider> providers = ServiceLoader.load(ClusterRouterProvider.class);
            for (ClusterRouterProvider provider : providers) {
                ClusterRouter clusterRouter = provider.getClusterRouter(name);
                if (clusterRouter == null) continue;
                provider.init();
                log.info("\u9009\u5b9a\u96c6\u7fa4\u8def\u7531\uff1a[{}] {}", (Object)name, provider.getClass());
                return clusterRouter;
            }
            throw new ClusterRouterNotFoundException(name);
        }
    }
}

